/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.dialogs.mindimdialog.MinimumSizeDialog;
import net.sourceforge.fidocadj.globals.Globals;

public class DialogAttachImage
extends MinimumSizeDialog {
    private final JFrame parent;
    private final JTextField fileName;
    private final JTextField resolution;
    private final JTextField xcoord;
    private final JTextField ycoord;
    private final JTextField xsize;
    private final JTextField ysize;
    private BufferedImage img;
    private boolean isCalculating;
    private static final int useResolution = 0;
    private static final int useSizeX = 1;
    private static final int useSizeY = 2;
    private boolean attach;
    private boolean showImage;

    public DialogAttachImage(JFrame jFrame) {
        super(500, 450, jFrame, Globals.messages.getString("Attach_image_t"), true);
        this.parent = jFrame;
        this.showImage = true;
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.messages.getString("Image_file_attach"));
        GridBagConstraints gridBagConstraints = DialogUtil.createConst(0, n, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        container.add((Component)jLabel, gridBagConstraints);
        this.fileName = new JTextField(10);
        this.fileName.setText("");
        this.fileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.loadImage();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.loadImage();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.loadImage();
            }
        });
        gridBagConstraints = DialogUtil.createConst(1, n, 1, 1, 100, 100, 13, 1, new Insets(6, 6, 6, 6));
        container.add((Component)this.fileName, gridBagConstraints);
        JButton jButton = new JButton(Globals.messages.getString("Browse"));
        gridBagConstraints = DialogUtil.createConst(2, n++, 1, 1, 100, 100, 10, 0, new Insets(6, 0, 12, 12));
        container.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(this.createBrowseActionListener());
        JLabel jLabel2 = new JLabel(Globals.messages.getString("Image_resolution"));
        gridBagConstraints = DialogUtil.createConst(0, n, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        container.add((Component)jLabel2, gridBagConstraints);
        this.resolution = new JTextField(10);
        this.resolution.setText("200");
        this.resolution.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(0);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(0);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(0);
            }
        });
        gridBagConstraints = DialogUtil.createConst(1, n++, 2, 1, 100, 100, 13, 1, new Insets(6, 6, 6, 6));
        container.add((Component)this.resolution, gridBagConstraints);
        JLabel jLabel3 = new JLabel(Globals.messages.getString("Image_size_mm"));
        gridBagConstraints = DialogUtil.createConst(0, n, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        container.add((Component)jLabel3, gridBagConstraints);
        this.xsize = new JTextField(5);
        this.xsize.setText("");
        this.xsize.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(1);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(1);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(1);
            }
        });
        gridBagConstraints = DialogUtil.createConst(1, n, 1, 1, 100, 100, 13, 1, new Insets(6, 6, 6, 6));
        container.add((Component)this.xsize, gridBagConstraints);
        this.ysize = new JTextField(5);
        this.ysize.setText("");
        this.ysize.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(2);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(2);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DialogAttachImage.this.calculateSizeAndResolution(2);
            }
        });
        gridBagConstraints = DialogUtil.createConst(2, n++, 1, 1, 100, 100, 13, 1, new Insets(6, 6, 6, 6));
        container.add((Component)this.ysize, gridBagConstraints);
        JLabel jLabel4 = new JLabel(Globals.messages.getString("Top_left_coords"));
        gridBagConstraints = DialogUtil.createConst(0, n, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        container.add((Component)jLabel4, gridBagConstraints);
        this.xcoord = new JTextField(5);
        this.xcoord.setText("0");
        gridBagConstraints = DialogUtil.createConst(1, n, 1, 1, 100, 100, 13, 1, new Insets(6, 6, 6, 6));
        container.add((Component)this.xcoord, gridBagConstraints);
        this.ycoord = new JTextField(5);
        this.ycoord.setText("0");
        gridBagConstraints = DialogUtil.createConst(2, n++, 1, 1, 100, 100, 13, 1, new Insets(6, 6, 6, 6));
        container.add((Component)this.ycoord, gridBagConstraints);
        JButton jButton2 = new JButton(Globals.messages.getString("No_img"));
        JButton jButton3 = new JButton(Globals.messages.getString("Ok_btn"));
        JButton jButton4 = new JButton(Globals.messages.getString("Cancel_btn"));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jButton3.setPreferredSize(jButton4.getPreferredSize());
        box.add(jButton2);
        box.add(Box.createHorizontalStrut(12));
        if (Globals.okCancelWinOrder) {
            box.add(jButton3);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton4);
        } else {
            box.add(jButton4);
            box.add(Box.createHorizontalStrut(12));
            box.add(jButton3);
        }
        gridBagConstraints = DialogUtil.createConst(1, n++, 3, 1, 0, 0, 13, 0, new Insets(12, 40, 0, 0));
        container.add((Component)box, gridBagConstraints);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogAttachImage.this.attach = true;
                DialogAttachImage.this.showImage = false;
                DialogAttachImage.this.fileName.setText("");
                DialogAttachImage.this.setVisible(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogAttachImage.this.validateForm()) {
                    DialogAttachImage.this.attach = true;
                    DialogAttachImage.this.setVisible(false);
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogAttachImage.this.setVisible(false);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogAttachImage.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, abstractAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(jButton3);
    }

    private void calculateSizeAndResolution(int n) {
        if (this.isCalculating || this.img == null) {
            return;
        }
        this.isCalculating = true;
        switch (n) {
            case 0: {
                try {
                    double d = this.getResolution();
                    double d2 = (double)this.img.getWidth() / d * 25.4;
                    double d3 = (double)this.img.getHeight() / d * 25.4;
                    this.xsize.setText(Globals.roundTo(d2, 3));
                    this.ysize.setText(Globals.roundTo(d3, 3));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.isCalculating = false;
                    return;
                }
            }
            case 1: {
                try {
                    double d = this.getSizeX();
                    double d4 = (double)this.img.getWidth() / d * 25.4;
                    this.setResolution(d4);
                    double d5 = (double)this.img.getHeight() / d4 * 25.4;
                    this.ysize.setText(Globals.roundTo(d5, 3));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.isCalculating = false;
                    return;
                }
            }
            case 2: {
                try {
                    double d = this.getSizeY();
                    double d6 = (double)this.img.getHeight() / d * 25.4;
                    this.setResolution(d6);
                    double d7 = (double)this.img.getWidth() / d6 * 25.4;
                    this.xsize.setText(Globals.roundTo(d7, 3));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.isCalculating = false;
                    return;
                }
            }
        }
        this.isCalculating = false;
    }

    private ActionListener createBrowseActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Globals.useNativeFileDialogs) {
                    FileDialog fileDialog = new FileDialog((Frame)DialogAttachImage.this.parent, Globals.messages.getString("Select_file_export"), 0);
                    fileDialog.setDirectory(new File(DialogAttachImage.this.fileName.getText()).getPath());
                    fileDialog.setVisible(true);
                    if (fileDialog.getFile() != null) {
                        String string = Globals.createCompleteFileName(fileDialog.getDirectory(), fileDialog.getFile());
                        DialogAttachImage.this.fileName.setText(string);
                    }
                } else {
                    JFileChooser jFileChooser = new JFileChooser(new File(DialogAttachImage.this.fileName.getText()).getPath());
                    int n = jFileChooser.showOpenDialog(null);
                    if (n == 0) {
                        DialogAttachImage.this.fileName.setText(jFileChooser.getSelectedFile().toString());
                    }
                }
                DialogAttachImage.this.loadImage();
                DialogAttachImage.this.calculateSizeAndResolution(0);
            }
        };
    }

    private boolean validateForm() {
        try {
            this.img = ImageIO.read(new File(this.getFilename()));
            this.getResolution();
            this.getSizeX();
            this.getSizeY();
            this.getCornerX();
            this.getCornerY();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.parent, Globals.messages.getString("Format_invalid"), "", 1);
            return false;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, Globals.messages.getString("Can_not_attach_image"), "", 1);
            return false;
        }
        return true;
    }

    private void loadImage() {
        try {
            this.img = ImageIO.read(new File(this.getFilename()));
        }
        catch (IOException iOException) {
            return;
        }
    }

    public boolean shouldAttach() {
        return this.attach;
    }

    public String getFilename() {
        return this.fileName.getText();
    }

    public void setFilename(String string) {
        this.fileName.setText(string);
    }

    public double getResolution() {
        return Double.parseDouble(this.resolution.getText());
    }

    public double getSizeX() {
        return Double.parseDouble(this.xsize.getText());
    }

    public double getSizeY() {
        return Double.parseDouble(this.ysize.getText());
    }

    public void setResolution(double d) {
        this.resolution.setText(Globals.roundTo(d));
    }

    public void setCorner(double d, double d2) {
        this.xcoord.setText(Globals.roundTo(d, 3));
        this.ycoord.setText(Globals.roundTo(d2, 3));
    }

    public double getCornerX() {
        return Double.parseDouble(this.xcoord.getText());
    }

    public boolean getShowImage() {
        return this.showImage;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public double getCornerY() {
        return Double.parseDouble(this.ycoord.getText());
    }
}

