/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.dialogs;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import javax.swing.JList;
import javax.swing.JPanel;
import net.sourceforge.fidocadj.graphic.swing.ColorSwing;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class CellLayer
extends JPanel {
    private final JList list;
    private final boolean isSelected;
    private final LayerDesc layer;

    CellLayer(LayerDesc layerDesc, JList jList, boolean bl) {
        this.layer = layerDesc;
        this.list = jList;
        this.isSelected = bl;
        this.setPreferredSize(new Dimension(150, 18));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.isSelected ? this.list.getSelectionBackground() : this.list.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        ColorSwing colorSwing = (ColorSwing)this.layer.getColor();
        graphics.setColor(colorSwing.getColorSwing());
        graphics.fillRect(2, 2, this.getHeight(), this.getHeight() - 4);
        if (this.layer.getVisible()) {
            if (this.isSelected) {
                graphics.setColor(this.list.getSelectionForeground());
            }
        } else {
            graphics.setColor(SystemColor.textInactiveText);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.drawString(this.layer.getDescription(), 6 * this.getHeight() / 4, (int)(3.8 * (double)this.getHeight() / 5.0));
    }
}

