/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.views;

import java.io.IOException;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.export.ExportInterface;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;
import net.sourceforge.fidocadj.primitives.PrimitivePCBPad;

public class Export {
    private final DrawingModel dmp;
    public static final int exportBorder = 6;

    public Export(DrawingModel drawingModel) {
        this.dmp = drawingModel;
    }

    private void exportAllObjects(ExportInterface exportInterface, boolean bl, MapCoordinates mapCoordinates) throws IOException {
        for (int i = 0; i < this.dmp.getPrimitiveVector().size(); ++i) {
            GraphicPrimitive graphicPrimitive = this.dmp.getPrimitiveVector().get(i);
            if (graphicPrimitive.getLayer() == this.dmp.drawOnlyLayer && !(graphicPrimitive instanceof PrimitiveMacro)) {
                if (!this.dmp.layerV.get((int)graphicPrimitive.getLayer()).isVisible && !bl) continue;
                graphicPrimitive.export(exportInterface, mapCoordinates);
                continue;
            }
            if (!(graphicPrimitive instanceof PrimitiveMacro)) continue;
            ((PrimitiveMacro)graphicPrimitive).setDrawOnlyLayer(this.dmp.drawOnlyLayer);
            ((PrimitiveMacro)graphicPrimitive).setExportInvisible(bl);
            if (!this.dmp.layerV.get((int)graphicPrimitive.getLayer()).isVisible && !bl) continue;
            graphicPrimitive.export(exportInterface, mapCoordinates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportHeader(ExportInterface exportInterface, MapCoordinates mapCoordinates) throws IOException {
        Export export = this;
        synchronized (export) {
            PointG pointG = new PointG(0, 0);
            DimensionG dimensionG = DrawingSize.getImageSize(this.dmp, 1.0, true, pointG);
            dimensionG.width += 6;
            dimensionG.height += 6;
            dimensionG.width = (int)((double)dimensionG.width * mapCoordinates.getXMagnitude());
            dimensionG.height = (int)((double)dimensionG.height * mapCoordinates.getYMagnitude());
            exportInterface.setDashUnit(mapCoordinates.getXMagnitude());
            exportInterface.exportStart(dimensionG, this.dmp.layerV, mapCoordinates.getXGridStep());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDrawing(ExportInterface exportInterface, boolean bl, MapCoordinates mapCoordinates) throws IOException {
        Export export = this;
        synchronized (export) {
            int n;
            if (this.dmp.drawOnlyLayer >= 0 && !this.dmp.drawOnlyPads) {
                this.exportAllObjects(exportInterface, bl, mapCoordinates);
            } else if (!this.dmp.drawOnlyPads) {
                for (n = 0; n < this.dmp.layerV.size(); ++n) {
                    this.dmp.setDrawOnlyLayer(n);
                    this.exportAllObjects(exportInterface, bl, mapCoordinates);
                }
                this.dmp.setDrawOnlyLayer(-1);
            }
            for (n = 0; n < this.dmp.getPrimitiveVector().size(); ++n) {
                GraphicPrimitive graphicPrimitive = this.dmp.getPrimitiveVector().get(n);
                if (graphicPrimitive instanceof PrimitivePCBPad) {
                    ((PrimitivePCBPad)graphicPrimitive).setDrawOnlyPads(true);
                    if (this.dmp.layerV.get((int)graphicPrimitive.getLayer()).isVisible || bl) {
                        graphicPrimitive.export(exportInterface, mapCoordinates);
                    }
                    ((PrimitivePCBPad)graphicPrimitive).setDrawOnlyPads(false);
                    continue;
                }
                if (!(graphicPrimitive instanceof PrimitiveMacro)) continue;
                ((PrimitiveMacro)graphicPrimitive).setExportInvisible(bl);
                ((PrimitiveMacro)graphicPrimitive).setDrawOnlyPads(true);
                if (this.dmp.layerV.get((int)graphicPrimitive.getLayer()).isVisible || bl) {
                    graphicPrimitive.export(exportInterface, mapCoordinates);
                }
                ((PrimitiveMacro)graphicPrimitive).setDrawOnlyPads(false);
                ((PrimitiveMacro)graphicPrimitive).resetExport();
            }
        }
    }
}

