/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.views;

import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;

public class Drawing {
    private final DrawingModel dmp;
    private boolean needHoles;
    private double oZ;
    private double oX;
    private double oY;
    private double oO;
    private GraphicPrimitive gg;
    private int i_index;
    private int j_index;

    public Drawing(DrawingModel drawingModel) {
        this.dmp = drawingModel;
    }

    public void drawSelectedHandles(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates) {
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected()) continue;
            graphicPrimitive.drawHandles(graphicsInterface, mapCoordinates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates) {
        if (mapCoordinates == null) {
            System.err.println("DrawingModel.draw: ouch... cs not initialized :-(");
            return;
        }
        Drawing drawing = this;
        synchronized (drawing) {
            if (this.dmp.changed || this.oZ != mapCoordinates.getXMagnitude() || this.oX != mapCoordinates.getXCenter() || this.oY != mapCoordinates.getYCenter() || this.oO != (double)mapCoordinates.getOrientation()) {
                this.oZ = mapCoordinates.getXMagnitude();
                this.oX = mapCoordinates.getXCenter();
                this.oY = mapCoordinates.getYCenter();
                this.oO = mapCoordinates.getOrientation();
                this.dmp.changed = false;
                for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
                    graphicPrimitive.setChanged(true);
                }
                if (!this.dmp.drawOnlyPads) {
                    mapCoordinates.resetMinMax();
                }
            }
            this.needHoles = this.dmp.drawOnlyPads;
            if (this.dmp.drawOnlyLayer >= 0 && !this.dmp.drawOnlyPads) {
                if (!this.dmp.layersUsed[this.dmp.drawOnlyLayer]) {
                    return;
                }
                this.drawPrimitives(this.dmp.drawOnlyLayer, graphicsInterface, mapCoordinates);
                return;
            }
            if (!this.dmp.drawOnlyPads) {
                this.j_index = 0;
                while (this.j_index < 16) {
                    if (this.dmp.layersUsed[this.j_index]) {
                        this.drawPrimitives(this.j_index, graphicsInterface, mapCoordinates);
                    }
                    ++this.j_index;
                }
            }
            if (this.needHoles) {
                this.i_index = 0;
                while (this.i_index < this.dmp.getPrimitiveVector().size()) {
                    this.gg = this.dmp.getPrimitiveVector().get(this.i_index);
                    if (this.gg.needsHoles()) {
                        this.gg.setDrawOnlyPads(true);
                        this.gg.draw(graphicsInterface, mapCoordinates, this.dmp.layerV);
                        this.gg.setDrawOnlyPads(false);
                    }
                    ++this.i_index;
                }
            }
        }
    }

    public final boolean getNeedHoles() {
        return this.needHoles;
    }

    private void drawPrimitives(int n, GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates) {
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (n > 0 && graphicPrimitive.layer > n) break;
            if (graphicPrimitive.containsLayer(n)) {
                graphicPrimitive.setDrawOnlyLayer(n);
                graphicPrimitive.draw(graphicsInterface, mapCoordinates, this.dmp.layerV);
            }
            if (!graphicPrimitive.needsHoles()) continue;
            this.needHoles = true;
        }
    }
}

