/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.model;

import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import net.sourceforge.fidocadj.circuit.ImageAsCanvas;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.circuit.model.ProcessElementsInterface;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.MacroDesc;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;

public class DrawingModel {
    public boolean[] layersUsed;
    public int maxLayer;
    public boolean drawOnlyPads;
    public int drawOnlyLayer;
    public ImageAsCanvas imgCanvas;
    private String macroFont;
    private int macroFontSize;
    public boolean changed;
    private Vector<GraphicPrimitive> primitiveVector;
    public Vector<LayerDesc> layerV;
    private Map<String, MacroDesc> library;

    public DrawingModel() {
        this.setPrimitiveVector(new Vector<GraphicPrimitive>(25));
        this.layerV = new Vector(16);
        this.library = new TreeMap<String, MacroDesc>();
        this.macroFont = "Courier New";
        this.imgCanvas = new ImageAsCanvas();
        this.drawOnlyPads = false;
        this.drawOnlyLayer = -1;
        this.layersUsed = new boolean[16];
        this.changed = true;
    }

    public void applyToAllElements(ProcessElementsInterface processElementsInterface) {
        for (GraphicPrimitive graphicPrimitive : this.primitiveVector) {
            processElementsInterface.doAction(graphicPrimitive);
        }
    }

    public Vector<LayerDesc> getLayers() {
        return this.layerV;
    }

    public void setLayers(final Vector<LayerDesc> vector) {
        this.layerV = vector;
        this.applyToAllElements(new ProcessElementsInterface(){

            @Override
            public void doAction(GraphicPrimitive graphicPrimitive) {
                if (graphicPrimitive instanceof PrimitiveMacro) {
                    ((PrimitiveMacro)graphicPrimitive).setLayers(vector);
                }
            }
        });
        this.changed = true;
    }

    public Map<String, MacroDesc> getLibrary() {
        return this.library;
    }

    public void setLibrary(Map<String, MacroDesc> map) {
        this.library = map;
        this.changed = true;
    }

    public void resetLibrary() {
        this.setLibrary(new TreeMap<String, MacroDesc>());
        this.changed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimitive(GraphicPrimitive graphicPrimitive, boolean bl, UndoActions undoActions) {
        DrawingModel drawingModel = this;
        synchronized (drawingModel) {
            this.getPrimitiveVector().add(graphicPrimitive);
            if (bl) {
                this.sortPrimitiveLayers();
            }
            if (undoActions != null) {
                undoActions.saveUndoState();
                undoActions.setModified(true);
                this.changed = true;
            }
        }
    }

    public void setTextFont(String string, int n, UndoActions undoActions) {
        int n2 = n;
        this.macroFont = string;
        this.macroFontSize = n2;
        for (GraphicPrimitive graphicPrimitive : this.getPrimitiveVector()) {
            graphicPrimitive.setMacroFont(string, n2);
        }
        this.changed = true;
        if (undoActions != null) {
            undoActions.setModified(true);
        }
    }

    public String getTextFont() {
        return this.macroFont;
    }

    public int getTextFontSize() {
        if (this.getPrimitiveVector().isEmpty()) {
            return this.macroFontSize;
        }
        int n = this.getPrimitiveVector().get(0).getMacroFontSize();
        if (n <= 0) {
            n = 1;
        }
        this.macroFontSize = n;
        return this.macroFontSize;
    }

    public void sortPrimitiveLayers() {
        int n;
        int n2;
        boolean bl = true;
        this.maxLayer = 0;
        for (n2 = this.getPrimitiveVector().size() / 2; n2 > 0; n2 /= 2) {
            for (int i = n2; i < this.getPrimitiveVector().size(); ++i) {
                for (n = i - n2; n >= 0 && this.getPrimitiveVector().get((int)(n + n2)).layer < this.getPrimitiveVector().get((int)n).layer; n -= n2) {
                    GraphicPrimitive graphicPrimitive = this.getPrimitiveVector().get(n);
                    this.getPrimitiveVector().set(n, this.getPrimitiveVector().get(n + n2));
                    this.getPrimitiveVector().set(n + n2, graphicPrimitive);
                }
            }
        }
        this.maxLayer = -1;
        int n3 = 0;
        block3: for (n2 = 0; n2 < 16; ++n2) {
            this.layersUsed[n2] = false;
            for (n = n3; n < this.getPrimitiveVector().size(); ++n) {
                GraphicPrimitive graphicPrimitive = this.getPrimitiveVector().get(n);
                if (graphicPrimitive.layer > this.maxLayer) {
                    this.maxLayer = graphicPrimitive.layer;
                }
                if (!graphicPrimitive.containsLayer(n2)) continue;
                this.layersUsed[n2] = true;
                n3 = n;
                for (int i = 0; i < n2; ++i) {
                    this.layersUsed[i] = true;
                }
                continue block3;
            }
        }
    }

    public final int getMaxLayer() {
        return this.maxLayer;
    }

    public boolean containsLayer(int n) {
        return this.layersUsed[n];
    }

    public boolean isEmpty() {
        return this.getPrimitiveVector().isEmpty();
    }

    public final void setChanged(boolean bl) {
        this.changed = bl;
    }

    public Vector<GraphicPrimitive> getPrimitiveVector() {
        return this.primitiveVector;
    }

    public void setPrimitiveVector(Vector<GraphicPrimitive> vector) {
        this.primitiveVector = vector;
    }

    public void setDrawOnlyPads(boolean bl) {
        this.drawOnlyPads = bl;
    }

    public void setDrawOnlyLayer(int n) {
        this.drawOnlyLayer = n;
    }
}

