/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fidocadj.circuit.HasChangedListener;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.globals.FileUtils;
import net.sourceforge.fidocadj.undo.LibraryUndoListener;
import net.sourceforge.fidocadj.undo.UndoActorListener;
import net.sourceforge.fidocadj.undo.UndoManager;
import net.sourceforge.fidocadj.undo.UndoState;

public class UndoActions
implements UndoActorListener {
    private final ParserActions pa;
    private final UndoManager um;
    private final Vector<String> tempDir;
    private static final int MAX_UNDO = 100;
    private boolean isModified;
    private String tempLibraryDirectory = "";
    private LibraryUndoListener libraryUndoListener;
    private HasChangedListener cl;

    public UndoActions(ParserActions parserActions) {
        this.pa = parserActions;
        this.um = new UndoManager(100);
        this.libraryUndoListener = null;
        this.tempDir = new Vector();
        this.cl = null;
    }

    public void undo() {
        UndoState undoState = this.um.undoPop();
        if (this.um.isNextOperationOnALibrary() && this.libraryUndoListener != null) {
            this.libraryUndoListener.undoLibrary(undoState.libraryDir);
        }
        if (!"".equals(undoState.text)) {
            StringBuffer stringBuffer = new StringBuffer(undoState.text);
            this.pa.parseString(stringBuffer);
        }
        this.isModified = undoState.isModified;
        this.pa.openFileName = undoState.fileName;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    public void redo() {
        UndoState undoState = this.um.undoRedo();
        if (undoState.libraryOperation && this.libraryUndoListener != null) {
            this.libraryUndoListener.undoLibrary(undoState.libraryDir);
        }
        if (!"".equals(undoState.text)) {
            StringBuffer stringBuffer = new StringBuffer(undoState.text);
            this.pa.parseString(stringBuffer);
        }
        this.isModified = undoState.isModified;
        this.pa.openFileName = undoState.fileName;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    @Override
    public void saveUndoState() {
        UndoState undoState = new UndoState();
        undoState.text = this.pa.getText(true).toString();
        undoState.isModified = this.isModified;
        undoState.fileName = this.pa.openFileName;
        undoState.libraryDir = this.tempLibraryDirectory;
        undoState.libraryOperation = false;
        this.um.undoPush(undoState);
        this.isModified = true;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    @Override
    public void saveUndoLibrary(String string) {
        this.tempLibraryDirectory = string;
        UndoState undoState = new UndoState();
        undoState.text = this.pa.getText(true).toString();
        undoState.libraryDir = this.tempLibraryDirectory;
        undoState.isModified = this.isModified;
        undoState.fileName = this.pa.openFileName;
        undoState.libraryOperation = true;
        this.tempDir.add(string);
        this.um.undoPush(undoState);
    }

    public void setLibraryUndoListener(LibraryUndoListener libraryUndoListener) {
        this.libraryUndoListener = libraryUndoListener;
    }

    public boolean getModified() {
        return this.isModified;
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
        if (this.cl != null) {
            this.cl.somethingHasChanged();
        }
    }

    public void setHasChangedListener(HasChangedListener hasChangedListener) {
        this.cl = hasChangedListener;
    }

    public void doTheDishes() {
        for (int i = 0; i < this.tempDir.size(); ++i) {
            try {
                FileUtils.deleteDirectory(new File(this.tempDir.get(i)));
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Warning: " + iOException);
            }
        }
    }
}

