/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import java.util.Vector;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.circuit.model.ProcessElementsInterface;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;

public class SelectionActions {
    private final DrawingModel dmp;

    public SelectionActions(DrawingModel drawingModel) {
        this.dmp = drawingModel;
    }

    public GraphicPrimitive getFirstSelectedPrimitive() {
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected()) continue;
            return graphicPrimitive;
        }
        return null;
    }

    public void applyToSelectedElements(ProcessElementsInterface processElementsInterface) {
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected()) continue;
            processElementsInterface.doAction(graphicPrimitive);
        }
    }

    public Vector<Boolean> getSelectionStateVector() {
        Vector<Boolean> vector = new Vector<Boolean>(this.dmp.getPrimitiveVector().size());
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            vector.add(graphicPrimitive.getSelected());
        }
        return vector;
    }

    public void setSelectionAll(boolean bl) {
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            graphicPrimitive.setSelected(bl);
        }
    }

    public void setSelectionStateVector(Vector<Boolean> vector) {
        int n = 0;
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            graphicPrimitive.setSelected(vector.get(n++));
        }
    }

    public boolean isUniquePrimitiveSelected() {
        boolean bl = true;
        boolean bl2 = false;
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected()) continue;
            if (bl2) {
                bl = false;
            }
            bl2 = true;
        }
        return bl2 && bl;
    }

    public boolean selectionCanBeSplitted() {
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected() || !(graphicPrimitive instanceof PrimitiveMacro) && !graphicPrimitive.hasName() && !graphicPrimitive.hasValue()) continue;
            return true;
        }
        return false;
    }

    public StringBuffer getSelectedString(boolean bl, ParserActions parserActions) {
        StringBuffer stringBuffer = new StringBuffer("[FIDOCAD]\n");
        stringBuffer.append(parserActions.registerConfiguration(bl));
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected()) continue;
            stringBuffer.append(graphicPrimitive.toString(bl));
        }
        return stringBuffer;
    }
}

