/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.export.ExportGraphic;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.layers.StandardLayers;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.MacroDesc;
import net.sourceforge.fidocadj.primitives.PrimitiveAdvText;
import net.sourceforge.fidocadj.primitives.PrimitiveBezier;
import net.sourceforge.fidocadj.primitives.PrimitiveComplexCurve;
import net.sourceforge.fidocadj.primitives.PrimitiveConnection;
import net.sourceforge.fidocadj.primitives.PrimitiveLine;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;
import net.sourceforge.fidocadj.primitives.PrimitiveOval;
import net.sourceforge.fidocadj.primitives.PrimitivePCBLine;
import net.sourceforge.fidocadj.primitives.PrimitivePCBPad;
import net.sourceforge.fidocadj.primitives.PrimitivePolygon;
import net.sourceforge.fidocadj.primitives.PrimitiveRectangle;

public class ParserActions {
    private final DrawingModel model;
    static final int MAX_TOKENS = 10000;
    static final boolean useWindowsLineFeed = false;
    public String openFileName = null;

    public ParserActions(DrawingModel drawingModel) {
        this.model = drawingModel;
    }

    public void parseString(StringBuffer stringBuffer) {
        this.model.getPrimitiveVector().clear();
        this.addString(stringBuffer, false);
        this.model.setChanged(true);
    }

    public StringBuffer splitMacros(StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        DrawingModel drawingModel = new DrawingModel();
        drawingModel.setLibrary(this.model.getLibrary());
        drawingModel.setLayers(this.model.getLayers());
        try {
            ParserActions parserActions = new ParserActions(drawingModel);
            parserActions.parseString(stringBuffer);
            File file = File.createTempFile("copy", ".fcd");
            file.deleteOnExit();
            String string = "";
            string = bl ? "fcda" : "fcd";
            ExportGraphic.export(file, drawingModel, string, 1.0, true, false, true, false, false);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF8"));
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                bufferedReader.close();
                return new StringBuffer("");
            }
            stringBuffer2 = new StringBuffer();
            do {
                stringBuffer2.append(string2);
                stringBuffer2.append("\n");
            } while ((string2 = bufferedReader.readLine()) != null);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error: " + iOException);
        }
        return stringBuffer2;
    }

    public StringBuffer getText(boolean bl) {
        StringBuffer stringBuffer = this.registerConfiguration(bl);
        for (GraphicPrimitive graphicPrimitive : this.model.getPrimitiveVector()) {
            stringBuffer.append(graphicPrimitive.toString(bl));
        }
        return stringBuffer;
    }

    public StringBuffer registerConfiguration(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            return stringBuffer;
        }
        if (Math.abs(2.0 - Globals.diameterConnection) > 1.0E-5) {
            stringBuffer.append("FJC C " + Globals.diameterConnection + "\n");
        }
        stringBuffer.append(this.checkAndRegisterLayers());
        if (Math.abs(Globals.lineWidth - 0.5) > 1.0E-5) {
            stringBuffer.append("FJC A " + Globals.lineWidth + "\n");
        }
        if (Math.abs(Globals.lineWidthCircles - 0.35) > 1.0E-5) {
            stringBuffer.append("FJC B " + Globals.lineWidthCircles + "\n");
        }
        return stringBuffer;
    }

    private StringBuffer checkAndRegisterLayers() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<LayerDesc> vector = this.model.getLayers();
        Vector<LayerDesc> vector2 = StandardLayers.createStandardLayers();
        for (int i = 0; i < vector.size(); ++i) {
            LayerDesc layerDesc = vector.get(i);
            if (!layerDesc.getModified()) continue;
            int n = layerDesc.getColor().getRGB();
            float f = layerDesc.getAlpha();
            stringBuffer.append("FJC L " + i + " " + n + " " + f + "\n");
            String string = vector2.get(i).getDescription();
            if (layerDesc.getDescription().equals(string)) continue;
            stringBuffer.append("FJC N " + i + " " + layerDesc.getDescription() + "\n");
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addString(StringBuffer stringBuffer, boolean bl) {
        boolean bl2 = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = this.model.getTextFont();
        int n = this.model.getTextFontSize();
        boolean bl3 = false;
        GraphicPrimitive graphicPrimitive = new PrimitiveLine(string, n);
        String[] stringArray = new String[10000];
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        int n2 = 0;
        int n3 = 0;
        String[] stringArray4 = new String[10000];
        int n4 = 0;
        int n5 = 0;
        stringBuffer2.ensureCapacity(256);
        ParserActions parserActions = this;
        synchronized (parserActions) {
            Vector<LayerDesc> vector = this.model.getLayers();
            char c = '\n';
            int n6 = 1;
            int n7 = 0;
            stringBuffer2.setLength(0);
            int n8 = stringBuffer.length();
            for (int i = 0; i < n8; ++i) {
                c = stringBuffer.charAt(i);
                if (c == '\n' || c == '\r' || i == n8 - 1) {
                    int n9;
                    bl3 = false;
                    if (i == n8 - 1 && c != '\n' && c != ' ') {
                        stringBuffer2.append(c);
                    }
                    ++n6;
                    stringArray[n7] = stringBuffer2.toString();
                    if (stringBuffer2.length() == 0) {
                        --n7;
                    }
                    try {
                        if (bl2 && !stringArray[0].equals("FCJ")) {
                            bl2 = this.registerPrimitivesWithFCJ(bl2, stringArray, graphicPrimitive, stringArray4, n4, bl);
                        }
                        if (stringArray[0].equals("FCJ")) {
                            if (bl2 && stringArray4[0].equals("MC")) {
                                n5 = 2;
                                graphicPrimitive = new PrimitiveMacro(this.model.getLibrary(), vector, string, n);
                                graphicPrimitive.parseTokens(stringArray4, n4 + 1);
                            } else if (bl2 && stringArray4[0].equals("LI")) {
                                graphicPrimitive = new PrimitiveLine(string, n);
                                for (n9 = 0; n9 < n7 + 1; ++n9) {
                                    stringArray4[n9 + n4 + 1] = stringArray[n9];
                                }
                                graphicPrimitive.parseTokens(stringArray4, (n4 += n7 + 1) + 1);
                                graphicPrimitive.setSelected(bl);
                                if (n4 > 5 && stringArray4[n4].equals("1")) {
                                    n5 = 2;
                                } else {
                                    this.model.addPrimitive(graphicPrimitive, false, null);
                                }
                            } else if (bl2 && stringArray4[0].equals("BE")) {
                                graphicPrimitive = new PrimitiveBezier(string, n);
                                for (n9 = 0; n9 < n7 + 1; ++n9) {
                                    stringArray4[n9 + n4 + 1] = stringArray[n9];
                                }
                                graphicPrimitive.parseTokens(stringArray4, (n4 += n7 + 1) + 1);
                                graphicPrimitive.setSelected(bl);
                                if (n4 > 5 && stringArray4[n4].equals("1")) {
                                    n5 = 2;
                                } else {
                                    this.model.addPrimitive(graphicPrimitive, false, null);
                                }
                            } else if (bl2 && (stringArray4[0].equals("RV") || stringArray4[0].equals("RP"))) {
                                graphicPrimitive = new PrimitiveRectangle(string, n);
                                for (n9 = 0; n9 < n7 + 1; ++n9) {
                                    stringArray4[n9 + n4 + 1] = stringArray[n9];
                                }
                                graphicPrimitive.parseTokens(stringArray4, (n4 += n7 + 1) + 1);
                                graphicPrimitive.setSelected(bl);
                                if (n4 > 2 && stringArray4[n4].equals("1")) {
                                    n5 = 2;
                                } else {
                                    this.model.addPrimitive(graphicPrimitive, false, null);
                                }
                            } else if (bl2 && (stringArray4[0].equals("EV") || stringArray4[0].equals("EP"))) {
                                graphicPrimitive = new PrimitiveOval(string, n);
                                for (n9 = 0; n9 < n7 + 1; ++n9) {
                                    stringArray4[n9 + n4 + 1] = stringArray[n9];
                                }
                                graphicPrimitive.parseTokens(stringArray4, (n4 += n7 + 1) + 1);
                                graphicPrimitive.setSelected(bl);
                                if (n4 > 2 && stringArray4[n4].equals("1")) {
                                    n5 = 2;
                                } else {
                                    this.model.addPrimitive(graphicPrimitive, false, null);
                                }
                            } else if (bl2 && (stringArray4[0].equals("PV") || stringArray4[0].equals("PP"))) {
                                graphicPrimitive = new PrimitivePolygon(string, n);
                                for (n9 = 0; n9 < n7 + 1; ++n9) {
                                    stringArray4[n9 + n4 + 1] = stringArray[n9];
                                }
                                graphicPrimitive.parseTokens(stringArray4, (n4 += n7 + 1) + 1);
                                graphicPrimitive.setSelected(bl);
                                if (n4 > 2 && stringArray4[n4].equals("1")) {
                                    n5 = 2;
                                } else {
                                    this.model.addPrimitive(graphicPrimitive, false, null);
                                }
                            } else if (bl2 && (stringArray4[0].equals("CV") || stringArray4[0].equals("CP"))) {
                                graphicPrimitive = new PrimitiveComplexCurve(string, n);
                                for (n9 = 0; n9 < n7 + 1; ++n9) {
                                    stringArray4[n9 + n4 + 1] = stringArray[n9];
                                }
                                graphicPrimitive.parseTokens(stringArray4, (n4 += n7 + 1) + 1);
                                graphicPrimitive.setSelected(bl);
                                if (n4 > 2 && stringArray4[n4].equals("1")) {
                                    n5 = 2;
                                } else {
                                    this.model.addPrimitive(graphicPrimitive, false, null);
                                }
                            } else if (bl2 && stringArray4[0].equals("PL")) {
                                n5 = 2;
                            } else if (bl2 && stringArray4[0].equals("PA")) {
                                n5 = 2;
                            } else if (bl2 && stringArray4[0].equals("SA")) {
                                n5 = 2;
                            }
                            bl2 = false;
                        } else if (stringArray[0].equals("FJC")) {
                            this.fidoConfig(stringArray, n7, vector);
                        } else if (stringArray[0].equals("LI")) {
                            n5 = 0;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n4 = n7;
                            bl2 = true;
                        } else if (stringArray[0].equals("BE")) {
                            n5 = 0;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n4 = n7;
                            bl2 = true;
                        } else if (stringArray[0].equals("MC")) {
                            n5 = 0;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n4 = n7;
                            bl2 = true;
                        } else if (stringArray[0].equals("TE")) {
                            bl2 = false;
                            n5 = 0;
                            graphicPrimitive = new PrimitiveAdvText();
                            graphicPrimitive.parseTokens(stringArray, n7 + 1);
                            graphicPrimitive.setSelected(bl);
                            this.model.addPrimitive(graphicPrimitive, false, null);
                        } else if (stringArray[0].equals("TY")) {
                            bl2 = false;
                            if (n5 == 2) {
                                --n5;
                                stringArray2 = new String[n7 + 1];
                                for (n9 = 0; n9 < n7 + 1; ++n9) {
                                    stringArray2[n9] = stringArray[n9];
                                }
                                n2 = n7;
                            } else if (n5 == 1) {
                                stringArray3 = new String[n7 + 1];
                                for (n9 = 0; n9 < n7 + 1; ++n9) {
                                    stringArray3[n9] = stringArray[n9];
                                }
                                n3 = n7;
                                if (stringArray2 != null) {
                                    graphicPrimitive.setName(stringArray2, n2 + 1);
                                }
                                graphicPrimitive.setValue(stringArray3, n3 + 1);
                                graphicPrimitive.setSelected(bl);
                                this.model.addPrimitive(graphicPrimitive, false, null);
                                n5 = 0;
                            } else {
                                graphicPrimitive = new PrimitiveAdvText();
                                graphicPrimitive.parseTokens(stringArray, n7 + 1);
                                graphicPrimitive.setSelected(bl);
                                this.model.addPrimitive(graphicPrimitive, false, null);
                            }
                        } else if (stringArray[0].equals("PL")) {
                            bl2 = true;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n5 = 0;
                            n4 = n7;
                            graphicPrimitive = new PrimitivePCBLine(string, n);
                            graphicPrimitive.parseTokens(stringArray, n7 + 1);
                            graphicPrimitive.setSelected(bl);
                        } else if (stringArray[0].equals("PA")) {
                            bl2 = true;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n5 = 0;
                            graphicPrimitive = new PrimitivePCBPad(string, n);
                            n4 = n7;
                            graphicPrimitive.parseTokens(stringArray, n7 + 1);
                            graphicPrimitive.setSelected(bl);
                        } else if (stringArray[0].equals("SA")) {
                            bl2 = true;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n4 = n7;
                            n5 = 0;
                            graphicPrimitive = new PrimitiveConnection(string, n);
                            graphicPrimitive.parseTokens(stringArray, n7 + 1);
                            graphicPrimitive.setSelected(bl);
                        } else if (stringArray[0].equals("EV") || stringArray[0].equals("EP")) {
                            n5 = 0;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n4 = n7;
                            bl2 = true;
                        } else if (stringArray[0].equals("RV") || stringArray[0].equals("RP")) {
                            n5 = 0;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n4 = n7;
                            bl2 = true;
                        } else if (stringArray[0].equals("PV") || stringArray[0].equals("PP")) {
                            n5 = 0;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n4 = n7;
                            bl2 = true;
                        } else if (stringArray[0].equals("CV") || stringArray[0].equals("CP")) {
                            n5 = 0;
                            for (n9 = 0; n9 < n7 + 1; ++n9) {
                                stringArray4[n9] = stringArray[n9];
                            }
                            n4 = n7;
                            bl2 = true;
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("Error encountered: " + iOException.toString());
                        System.out.println("string parsing line: " + n6);
                        bl2 = true;
                        n5 = 0;
                        for (n9 = 0; n9 < n7 + 1; ++n9) {
                            stringArray4[n9] = stringArray[n9];
                        }
                        n4 = n7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("I could not read a number at line: " + n6);
                        bl2 = true;
                        n5 = 0;
                        for (n9 = 0; n9 < n7 + 1; ++n9) {
                            stringArray4[n9] = stringArray[n9];
                        }
                        n4 = n7;
                    }
                    n7 = 0;
                    stringBuffer2.setLength(0);
                    continue;
                }
                if (c == ' ' && !bl3) {
                    stringArray[n7] = stringBuffer2.toString();
                    stringBuffer2.setLength(0);
                    if (++n7 < 10000) continue;
                    System.out.println("Too much tokens!");
                    System.out.println("string parsing line: " + n6);
                    n7 = 9999;
                    bl3 = true;
                    continue;
                }
                if (bl3) continue;
                stringBuffer2.append(c);
            }
            try {
                this.registerPrimitivesWithFCJ(bl2, stringArray, graphicPrimitive, stringArray4, n4, bl);
            }
            catch (IOException iOException) {
                System.out.println("Error encountered: " + iOException.toString());
                System.out.println("string parsing line: " + n6);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("I could not read a number at line: " + n6);
            }
            this.model.sortPrimitiveLayers();
        }
    }

    private void fidoConfig(String[] stringArray, int n, Vector<LayerDesc> vector) {
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        if (stringArray[1].equals("C")) {
            d = Double.parseDouble(stringArray[2]);
        } else if (stringArray[1].equals("L")) {
            int n2 = Integer.parseInt(stringArray[2]);
            if (n2 >= 0 && n2 < vector.size()) {
                int n3 = Integer.parseInt(stringArray[3]);
                float f = Float.parseFloat(stringArray[4]);
                LayerDesc layerDesc = vector.get(n2);
                layerDesc.getColor().setRGB(n3);
                layerDesc.setAlpha(f);
                layerDesc.setModified(true);
            }
        } else if (stringArray[1].equals("N")) {
            int n4 = Integer.parseInt(stringArray[2]);
            if (n4 >= 0 && n4 < vector.size()) {
                String string = "";
                StringBuffer stringBuffer = new StringBuffer(25);
                for (int i = 3; i < n + 1; ++i) {
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(" ");
                }
                string = stringBuffer.toString();
                LayerDesc layerDesc = vector.get(n4);
                layerDesc.setDescription(string);
                layerDesc.setModified(true);
            }
        } else if (stringArray[1].equals("A")) {
            d2 = Double.parseDouble(stringArray[2]);
        } else if (stringArray[1].equals("B")) {
            d3 = Double.parseDouble(stringArray[2]);
        }
        if (d > 0.0) {
            Globals.diameterConnection = d;
        }
        if (d2 > 0.0) {
            Globals.lineWidth = d2;
        }
        if (d3 > 0.0) {
            Globals.lineWidthCircles = d3;
        }
    }

    private boolean registerPrimitivesWithFCJ(boolean bl, String[] stringArray, GraphicPrimitive graphicPrimitive, String[] stringArray2, int n, boolean bl2) throws IOException {
        String string = this.model.getTextFont();
        int n2 = this.model.getTextFontSize();
        Vector<LayerDesc> vector = this.model.getLayers();
        GraphicPrimitive graphicPrimitive2 = graphicPrimitive;
        boolean bl3 = bl;
        boolean bl4 = false;
        if (bl3 && !stringArray[0].equals("FCJ")) {
            if (stringArray2[0].equals("MC")) {
                graphicPrimitive2 = new PrimitiveMacro(this.model.getLibrary(), vector, string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("LI")) {
                graphicPrimitive2 = new PrimitiveLine(string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("BE")) {
                graphicPrimitive2 = new PrimitiveBezier(string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("RP") || stringArray2[0].equals("RV")) {
                graphicPrimitive2 = new PrimitiveRectangle(string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("EP") || stringArray2[0].equals("EV")) {
                graphicPrimitive2 = new PrimitiveOval(string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("PP") || stringArray2[0].equals("PV")) {
                graphicPrimitive2 = new PrimitivePolygon(string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("PL")) {
                graphicPrimitive2 = new PrimitivePCBLine(string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("CP") || stringArray2[0].equals("CV")) {
                graphicPrimitive2 = new PrimitiveComplexCurve(string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("PA")) {
                graphicPrimitive2 = new PrimitivePCBPad(string, n2);
                bl4 = true;
            } else if (stringArray2[0].equals("SA")) {
                graphicPrimitive2 = new PrimitiveConnection(string, n2);
                bl4 = true;
            }
        }
        if (bl4) {
            graphicPrimitive2.parseTokens(stringArray2, n + 1);
            graphicPrimitive2.setSelected(bl2);
            this.model.addPrimitive(graphicPrimitive2, false, null);
            bl3 = false;
        }
        return bl3;
    }

    public void loadLibraryInJar(URL uRL, String string) {
        String string2 = string;
        if (uRL == null) {
            if (string2 == null) {
                string2 = "";
            }
            System.out.println("Resource not found! " + string2);
            return;
        }
        try {
            this.readLibraryBufferedReader(new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF8")), string2);
        }
        catch (IOException iOException) {
            System.out.println("Problems reading library: " + uRL.toString());
        }
    }

    public void readLibraryFile(String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "UTF8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string2 = "";
        string2 = Globals.getFileNameOnly(string);
        if ("FCDstdlib".equals(string2)) {
            string2 = "";
        }
        this.readLibraryBufferedReader(bufferedReader, string2);
        bufferedReader.close();
    }

    public void readLibraryBufferedReader(BufferedReader bufferedReader, String string) throws IOException {
        Object object = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        while ((string5 = bufferedReader.readLine()) != null) {
            int n;
            StringBuffer stringBuffer;
            if ((string5 = string5.trim()).length() <= 1) continue;
            if (string5.charAt(0) == '{') {
                string3 = "";
                stringBuffer = new StringBuffer(25);
                for (n = 1; n < string5.length() && string5.charAt(n) != '}'; ++n) {
                    stringBuffer.append(string5.charAt(n));
                }
                string3 = stringBuffer.toString().trim();
                if (n != string5.length()) continue;
                IOException iOException = new IOException("Category non terminated with }.");
                throw iOException;
            }
            if (string5.charAt(0) == '[') {
                int n2;
                object = "";
                string2 = "";
                stringBuffer = new StringBuffer(25);
                for (n = 1; string5.charAt(n) != ' ' && string5.charAt(n) != ']' && n < string5.length(); ++n) {
                    stringBuffer.append(string5.charAt(n));
                }
                object = stringBuffer.toString().trim();
                stringBuffer = new StringBuffer(25);
                for (n2 = n; n2 < string5.length() && string5.charAt(n2) != ']'; ++n2) {
                    stringBuffer.append(string5.charAt(n2));
                }
                string2 = stringBuffer.toString();
                if (n2 == string5.length()) {
                    IOException iOException = new IOException("Macro name non terminated with ].");
                    throw iOException;
                }
                if ("FIDOLIB".equals(object)) {
                    string4 = string2.trim();
                    continue;
                }
                if (!"".equals(string)) {
                    object = string + "." + (String)object;
                }
                object = ((String)object).toLowerCase(new Locale("en"));
                this.model.getLibrary().put((String)object, new MacroDesc((String)object, "", "", "", "", string));
                continue;
            }
            if ("".equals(object)) continue;
            object = ((String)object).toLowerCase(new Locale("en"));
            MacroDesc macroDesc = this.model.getLibrary().get(object);
            if (macroDesc == null) {
                return;
            }
            macroDesc.name = string2;
            macroDesc.key = object;
            macroDesc.category = string3;
            macroDesc.library = string4;
            macroDesc.filename = string;
            macroDesc.description = macroDesc.description + "\n" + string5;
        }
    }

    public void loadLibraryDirectory(String string) {
        File file = new File(string);
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase(new Locale("en")).endsWith(".fcl");
            }
        });
        if (!file.exists() || stringArray == null) {
            if (!"".equals(string)) {
                System.out.println("Warning! Library directory is incorrect:");
                System.out.println(string);
            }
            System.out.println("Activated FidoCadJ internal libraries and symbols.");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            try {
                this.readLibraryFile(file2.getPath());
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Problems reading library " + file2.getName() + " " + iOException);
            }
        }
    }
}

