/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import java.util.Vector;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.PrimitivesParInterface;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;
import net.sourceforge.fidocadj.primitives.PrimitiveOval;
import net.sourceforge.fidocadj.primitives.PrimitiveRectangle;

public class HandleActions {
    private final DrawingModel dmp;
    private final EditorActions edt;
    private final UndoActions ua;
    private final SelectionActions sa;
    private boolean firstDrag;
    private GraphicPrimitive primBeingDragged;
    private int handleBeingDragged;
    private int opx;
    private int opy;
    private boolean hasMoved;
    private int oldpx;
    private int oldpy;

    public HandleActions(DrawingModel drawingModel, EditorActions editorActions, SelectionActions selectionActions, UndoActions undoActions) {
        this.dmp = drawingModel;
        this.edt = editorActions;
        this.ua = undoActions;
        this.sa = selectionActions;
        this.firstDrag = false;
        this.handleBeingDragged = -1;
    }

    public void dragPrimitives(PrimitivesParInterface primitivesParInterface, int n, int n2, MapCoordinates mapCoordinates) {
        if (this.handleBeingDragged != -2) {
            return;
        }
        this.firstDrag = false;
        int n3 = mapCoordinates.unmapXsnap(n) - this.oldpx;
        int n4 = mapCoordinates.unmapYsnap(n2) - this.oldpy;
        this.oldpx = mapCoordinates.unmapXsnap(n);
        this.oldpy = mapCoordinates.unmapXsnap(n2);
        if (n3 == 0 && n4 == 0) {
            return;
        }
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected()) continue;
            if (graphicPrimitive instanceof PrimitiveMacro) {
                ((PrimitiveMacro)graphicPrimitive).setDrawOnlyLayer(-1);
            }
            for (int i = 0; i < graphicPrimitive.getControlPointNumber(); ++i) {
                graphicPrimitive.virtualPoint[i].x += n3;
                graphicPrimitive.virtualPoint[i].y += n4;
            }
            graphicPrimitive.setChanged(true);
        }
        primitivesParInterface.forcesRepaint();
    }

    public void dragHandleStart(int n, int n2, int n3, boolean bl, MapCoordinates mapCoordinates) {
        int n4;
        int n5 = 0;
        int n6 = n4 = Integer.MAX_VALUE;
        this.hasMoved = false;
        Vector<LayerDesc> vector = this.dmp.getLayers();
        this.oldpx = mapCoordinates.unmapXnosnap(n);
        this.oldpy = mapCoordinates.unmapXnosnap(n2);
        this.firstDrag = true;
        int n7 = Math.abs(mapCoordinates.unmapXnosnap(n + n3) - mapCoordinates.unmapXnosnap(n));
        if (n7 < 2) {
            n7 = 2;
        }
        for (int i = 0; i < this.dmp.getPrimitiveVector().size(); ++i) {
            GraphicPrimitive graphicPrimitive = this.dmp.getPrimitiveVector().get(i);
            int n8 = graphicPrimitive.getLayer();
            if (n8 < vector.size() && !vector.get((int)n8).isVisible && !(graphicPrimitive instanceof PrimitiveMacro)) continue;
            if (graphicPrimitive.selectedState) {
                this.handleBeingDragged = graphicPrimitive.onHandle(mapCoordinates, n, n2);
                if (this.handleBeingDragged != -1) {
                    this.primBeingDragged = graphicPrimitive;
                    continue;
                }
            }
            if ((n6 = graphicPrimitive.getDistanceToPoint(this.oldpx, this.oldpy)) > n4) continue;
            n5 = i;
            n4 = n6;
        }
        if (n4 < n7 && this.handleBeingDragged < 0) {
            this.primBeingDragged = this.dmp.getPrimitiveVector().get(n5);
            if (!bl && !this.primBeingDragged.getSelected()) {
                this.sa.setSelectionAll(false);
            }
            if (!bl) {
                this.primBeingDragged.setSelected(true);
            }
            this.handleBeingDragged = -2;
            this.firstDrag = true;
            this.oldpx = mapCoordinates.unmapXsnap(n);
            this.oldpy = mapCoordinates.unmapXsnap(n2);
        } else if (this.handleBeingDragged < 0) {
            this.oldpx = mapCoordinates.unmapXsnap(n);
            this.oldpy = mapCoordinates.unmapXsnap(n2);
            this.handleBeingDragged = -3;
        }
    }

    public void dragHandleEnd(PrimitivesParInterface primitivesParInterface, int n, int n2, boolean bl, MapCoordinates mapCoordinates) {
        primitivesParInterface.setEvidenceRect(0, 0, -1, -1);
        if (this.handleBeingDragged < 0) {
            if (this.handleBeingDragged == -3) {
                int n3 = Math.min(this.oldpx, mapCoordinates.unmapXnosnap(n));
                int n4 = Math.min(this.oldpy, mapCoordinates.unmapYnosnap(n2));
                int n5 = Math.max(this.oldpx, mapCoordinates.unmapXnosnap(n));
                int n6 = Math.max(this.oldpy, mapCoordinates.unmapYnosnap(n2));
                if (!bl) {
                    this.sa.setSelectionAll(false);
                }
                this.edt.selectRect(n3, n4, n5 - n3, n6 - n4);
            }
            if (this.handleBeingDragged == -2 && this.hasMoved && this.ua != null) {
                this.ua.saveUndoState();
            }
            this.handleBeingDragged = -1;
            return;
        }
        this.handleBeingDragged = -1;
        if (this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public void dragHandleDrag(PrimitivesParInterface primitivesParInterface, int n, int n2, MapCoordinates mapCoordinates, boolean bl) {
        int n3;
        this.hasMoved = true;
        boolean bl2 = false;
        if (this.handleBeingDragged < 0) {
            if (this.handleBeingDragged == -2) {
                this.dragPrimitives(primitivesParInterface, n, n2, mapCoordinates);
            }
            if (this.handleBeingDragged == -3) {
                int n4 = mapCoordinates.mapXi(this.oldpx, this.oldpy, false);
                int n5 = mapCoordinates.mapYi(this.oldpx, this.oldpy, false);
                int n6 = this.opx;
                int n7 = this.opy;
                if (this.opx > n4 && n < n4) {
                    bl2 = true;
                }
                if (this.opy > n5 && n2 < n5) {
                    bl2 = true;
                }
                if (!this.firstDrag) {
                    int n8 = Math.min(n4, n6);
                    int n9 = Math.min(n5, n7);
                    int n10 = Math.abs(n6 - n4);
                    int n11 = Math.abs(n7 - n5);
                    n6 = n;
                    n7 = n2;
                    this.opx = n;
                    this.opy = n2;
                    primitivesParInterface.setEvidenceRect(Math.min(n4, n6), Math.min(n5, n7), Math.abs(n6 - n4), Math.abs(n7 - n5));
                    n8 = Math.min(n8, Math.min(n4, n6));
                    n9 = Math.min(n9, Math.min(n5, n7));
                    n10 = Math.max(n10, Math.abs(n6 - n4));
                    n11 = Math.max(n11, Math.abs(n7 - n5));
                    if (bl2) {
                        primitivesParInterface.forcesRepaint();
                    } else {
                        primitivesParInterface.forcesRepaint(n8, n9, n10 + 10, n11 + 10);
                    }
                    return;
                }
                n6 = n;
                n7 = n2;
                this.opx = n;
                this.opy = n2;
                this.firstDrag = false;
            }
            return;
        }
        if (!this.firstDrag) {
            primitivesParInterface.forcesRepaint();
        }
        this.firstDrag = false;
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].x = mapCoordinates.unmapXsnap(n);
        if (!bl || !(this.primBeingDragged instanceof PrimitiveOval) && !(this.primBeingDragged instanceof PrimitiveRectangle)) {
            n3 = n2;
        } else {
            int n12 = 0;
            if (this.handleBeingDragged == 0) {
                n12 = 1;
            }
            n3 = mapCoordinates.mapYi(this.primBeingDragged.virtualPoint[n12].x, this.primBeingDragged.virtualPoint[n12].y, false) + n - mapCoordinates.mapXi(this.primBeingDragged.virtualPoint[n12].x, this.primBeingDragged.virtualPoint[n12].y, false);
        }
        this.primBeingDragged.virtualPoint[this.handleBeingDragged].y = mapCoordinates.unmapYsnap(n3);
        this.primBeingDragged.setChanged(true);
    }
}

