/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import net.sourceforge.fidocadj.circuit.controllers.AddElements;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.PrimitivesParInterface;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.layers.StandardLayers;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.PrimitiveAdvText;
import net.sourceforge.fidocadj.primitives.PrimitiveComplexCurve;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;
import net.sourceforge.fidocadj.primitives.PrimitivePolygon;
import net.sourceforge.fidocadj.toolbars.ChangeSelectionListener;

public class ElementsEdtActions {
    protected final DrawingModel dmp;
    protected final UndoActions ua;
    protected final EditorActions edt;
    final SelectionActions sa;
    final AddElements ae;
    private ChangeSelectionListener selectionListener;
    public int currentLayer;
    public int[] xpoly;
    public int[] ypoly;
    public String macroKey;
    public int clickNumber;
    public transient GraphicPrimitive primEdit;
    public int actionSelected;
    public boolean successiveMove;
    public static final int NPOLY = 256;
    public static final int NONE = 0;
    public static final int SELECTION = 1;
    public static final int ZOOM = 2;
    public static final int HAND = 3;
    public static final int LINE = 4;
    public static final int TEXT = 5;
    public static final int BEZIER = 6;
    public static final int POLYGON = 7;
    public static final int ELLIPSE = 8;
    public static final int RECTANGLE = 9;
    public static final int CONNECTION = 10;
    public static final int PCB_LINE = 11;
    public static final int PCB_PAD = 12;
    public static final int MACRO = 13;
    public static final int COMPLEXCURVE = 14;
    protected PrimitivesParInterface primitivesParListener;

    public ElementsEdtActions(DrawingModel drawingModel, SelectionActions selectionActions, UndoActions undoActions, EditorActions editorActions) {
        this.dmp = drawingModel;
        this.ua = undoActions;
        this.ae = new AddElements(this.dmp, this.ua);
        this.edt = editorActions;
        this.sa = selectionActions;
        this.xpoly = new int[256];
        this.ypoly = new int[256];
        this.currentLayer = 0;
        this.primEdit = null;
        this.selectionListener = null;
        this.primitivesParListener = null;
        this.actionSelected = 1;
    }

    public void setChangeSelectionListener(ChangeSelectionListener changeSelectionListener) {
        this.selectionListener = changeSelectionListener;
    }

    public AddElements getAddElements() {
        return this.ae;
    }

    public void setPrimitivesParListener(PrimitivesParInterface primitivesParInterface) {
        this.primitivesParListener = primitivesParInterface;
    }

    public boolean isEnteringMacro() {
        return this.primEdit instanceof PrimitiveMacro;
    }

    public void setState(int n, String string) {
        this.actionSelected = n;
        this.clickNumber = 0;
        this.successiveMove = false;
        this.macroKey = string;
    }

    public void rotateMacro() {
        if (this.primEdit instanceof PrimitiveMacro) {
            this.primEdit.rotatePrimitive(false, this.primEdit.getFirstPoint().x, this.primEdit.getFirstPoint().y);
        }
    }

    public void mirrorMacro() {
        if (this.primEdit instanceof PrimitiveMacro) {
            this.primEdit.mirrorPrimitive(this.primEdit.getFirstPoint().x);
        }
    }

    public boolean handleClick(MapCoordinates mapCoordinates, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        if (this.clickNumber > 255) {
            this.clickNumber = 255;
        }
        if (this.actionSelected != 13) {
            this.primEdit = null;
        }
        if (bl && this.actionSelected == 13) {
            this.actionSelected = 1;
            if (this.selectionListener != null) {
                this.selectionListener.setSelectionState(this.actionSelected, "");
            }
            this.primEdit = null;
            return true;
        }
        if (bl && this.actionSelected != 0 && this.actionSelected != 1 && this.actionSelected != 2 && this.actionSelected != 5 && this.primitivesParListener != null) {
            this.primitivesParListener.selectAndSetProperties(n, n2);
            return false;
        }
        switch (this.actionSelected) {
            case 0: {
                this.clickNumber = 0;
                break;
            }
            case 1: {
                this.clickNumber = 0;
                if (bl3 && this.primitivesParListener != null) {
                    this.primitivesParListener.setPropertiesForPrimitive();
                    break;
                }
                if (bl && this.primitivesParListener != null) {
                    this.primitivesParListener.showPopUpMenu(n, n2);
                    break;
                }
                this.edt.handleSelection(mapCoordinates, n, n2, bl2);
                break;
            }
            case 2: {
                if (this.primitivesParListener == null) break;
                this.primitivesParListener.changeZoomByStep(!bl, n, n2, 1.5);
                break;
            }
            case 10: {
                this.ae.addConnection(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapXsnap(n2), this.currentLayer);
                bl4 = true;
                break;
            }
            case 12: {
                this.ae.addPCBPad(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2), this.currentLayer);
                bl4 = true;
                break;
            }
            case 4: {
                if (bl3) {
                    this.clickNumber = 0;
                    break;
                }
                this.successiveMove = false;
                this.clickNumber = this.ae.addLine(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2), this.xpoly, this.ypoly, this.currentLayer, ++this.clickNumber, bl);
                bl4 = true;
                break;
            }
            case 5: {
                if (bl3 && this.primitivesParListener != null) {
                    this.primitivesParListener.selectAndSetProperties(n, n2);
                    break;
                }
                PrimitiveAdvText primitiveAdvText = new PrimitiveAdvText(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2), 3, 4, this.dmp.getTextFont(), 0, 0, "String", this.currentLayer);
                this.sa.setSelectionAll(false);
                this.dmp.addPrimitive(primitiveAdvText, true, this.ua);
                primitiveAdvText.setSelected(true);
                bl4 = true;
                if (this.primitivesParListener == null) break;
                this.primitivesParListener.setPropertiesForPrimitive();
                break;
            }
            case 6: {
                bl4 = true;
                if (bl) {
                    this.clickNumber = 0;
                    break;
                }
                if (bl3) {
                    this.successiveMove = false;
                }
                this.clickNumber = this.ae.addBezier(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2), this.xpoly, this.ypoly, this.currentLayer, ++this.clickNumber);
                break;
            }
            case 7: {
                if (bl3) {
                    PrimitivePolygon primitivePolygon = new PrimitivePolygon(false, this.currentLayer, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
                    for (int i = 1; i <= this.clickNumber; ++i) {
                        primitivePolygon.addPoint(this.xpoly[i], this.ypoly[i]);
                    }
                    this.dmp.addPrimitive(primitivePolygon, true, this.ua);
                    this.clickNumber = 0;
                    bl4 = true;
                    break;
                }
                ++this.clickNumber;
                this.successiveMove = false;
                if (this.clickNumber == 256) {
                    return false;
                }
                this.xpoly[this.clickNumber] = mapCoordinates.unmapXsnap(n);
                this.ypoly[this.clickNumber] = mapCoordinates.unmapYsnap(n2);
                break;
            }
            case 14: {
                if (bl3) {
                    PrimitiveComplexCurve primitiveComplexCurve = new PrimitiveComplexCurve(false, false, this.currentLayer, false, false, 0, 3, 2, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
                    for (int i = 1; i <= this.clickNumber; ++i) {
                        primitiveComplexCurve.addPoint(this.xpoly[i], this.ypoly[i]);
                    }
                    this.dmp.addPrimitive(primitiveComplexCurve, true, this.ua);
                    this.clickNumber = 0;
                    bl4 = true;
                    break;
                }
                ++this.clickNumber;
                this.successiveMove = false;
                if (this.clickNumber == 256) {
                    return false;
                }
                this.xpoly[this.clickNumber] = mapCoordinates.unmapXsnap(n);
                this.ypoly[this.clickNumber] = mapCoordinates.unmapYsnap(n2);
                break;
            }
            case 8: {
                this.successiveMove = false;
                this.clickNumber = this.ae.addEllipse(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2), this.xpoly, this.ypoly, this.currentLayer, ++this.clickNumber, bl2 && this.clickNumber > 0);
                bl4 = true;
                break;
            }
            case 9: {
                this.successiveMove = false;
                this.clickNumber = this.ae.addRectangle(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2), this.xpoly, this.ypoly, this.currentLayer, ++this.clickNumber, bl2 && this.clickNumber > 0);
                bl4 = true;
                break;
            }
            case 11: {
                if (bl3) {
                    this.clickNumber = 0;
                    break;
                }
                this.successiveMove = false;
                this.clickNumber = this.ae.addPCBLine(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2), this.xpoly, this.ypoly, this.currentLayer, ++this.clickNumber, bl, this.ae.getPCB_thickness());
                bl4 = true;
                break;
            }
            case 13: {
                this.successiveMove = false;
                this.primEdit = this.ae.addMacro(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2), this.sa, this.primEdit, this.macroKey);
                bl4 = true;
                break;
            }
        }
        return bl4;
    }

    public void drawPrimEdit(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates) {
        if (this.primEdit != null) {
            this.primEdit.draw(graphicsInterface, mapCoordinates, StandardLayers.createEditingLayerArray());
        }
    }

    public void showClicks(GraphicsInterface graphicsInterface, MapCoordinates mapCoordinates) {
        graphicsInterface.setColor(graphicsInterface.getColor().red());
        int n = Math.round(graphicsInterface.getScreenDensity() / 112.0f);
        graphicsInterface.applyStroke(2.0f * (float)n, 0);
        for (int i = 1; i <= this.clickNumber; ++i) {
            int n2 = mapCoordinates.mapXi(this.xpoly[i], this.ypoly[i], false);
            int n3 = mapCoordinates.mapYi(this.xpoly[i], this.ypoly[i], false);
            graphicsInterface.drawLine(n2 - 15 * n, n3, n2 + 15 * n, n3);
            graphicsInterface.drawLine(n2, n3 - 15 * n, n2, n3 + 15 * n);
        }
    }

    public int getSelectionState() {
        return this.actionSelected;
    }

    public void setPrimEdit(GraphicPrimitive graphicPrimitive) {
        this.primEdit = graphicPrimitive;
    }

    public GraphicPrimitive getPrimEdit() {
        return this.primEdit;
    }
}

