/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import java.util.Vector;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.circuit.model.ProcessElementsInterface;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;

public class EditorActions {
    private final DrawingModel dmp;
    private final UndoActions ua;
    private final SelectionActions sa;
    public int sel_tolerance = 10;

    public EditorActions(DrawingModel drawingModel, SelectionActions selectionActions, UndoActions undoActions) {
        this.dmp = drawingModel;
        this.ua = undoActions;
        this.sa = selectionActions;
        this.sel_tolerance = 10;
    }

    public void setSelectionTolerance(int n) {
        this.sel_tolerance = n;
    }

    public int getSelectionTolerance() {
        return this.sel_tolerance;
    }

    public void rotateAllSelected() {
        GraphicPrimitive graphicPrimitive = this.sa.getFirstSelectedPrimitive();
        if (graphicPrimitive == null) {
            return;
        }
        final int n = graphicPrimitive.getFirstPoint().x;
        final int n2 = graphicPrimitive.getFirstPoint().y;
        this.sa.applyToSelectedElements(new ProcessElementsInterface(){

            @Override
            public void doAction(GraphicPrimitive graphicPrimitive) {
                graphicPrimitive.rotatePrimitive(false, n, n2);
            }
        });
        if (this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public void moveAllSelected(final int n, final int n2) {
        this.sa.applyToSelectedElements(new ProcessElementsInterface(){

            @Override
            public void doAction(GraphicPrimitive graphicPrimitive) {
                graphicPrimitive.movePrimitive(n, n2);
            }
        });
        if (this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public void mirrorAllSelected() {
        GraphicPrimitive graphicPrimitive = this.sa.getFirstSelectedPrimitive();
        if (graphicPrimitive == null) {
            return;
        }
        final int n = graphicPrimitive.getFirstPoint().x;
        this.sa.applyToSelectedElements(new ProcessElementsInterface(){

            @Override
            public void doAction(GraphicPrimitive graphicPrimitive) {
                graphicPrimitive.mirrorPrimitive(n);
            }
        });
        if (this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public void deleteAllSelected(boolean bl) {
        Vector<GraphicPrimitive> vector = this.dmp.getPrimitiveVector();
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.get(i).getSelected()) continue;
            vector.remove(vector.get(i--));
        }
        if (bl && this.ua != null) {
            this.ua.saveUndoState();
        }
    }

    public boolean setLayerForSelectedPrimitives(int n) {
        boolean bl = false;
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            if (!graphicPrimitive.getSelected() || graphicPrimitive instanceof PrimitiveMacro) continue;
            graphicPrimitive.setLayer(n);
            bl = true;
        }
        if (bl) {
            this.dmp.sortPrimitiveLayers();
            this.dmp.setChanged(true);
            this.ua.saveUndoState();
        }
        return bl;
    }

    public int distancePrimitive(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        Vector<LayerDesc> vector = this.dmp.getLayers();
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            int n5 = graphicPrimitive.getDistanceToPoint(n, n2);
            if (n5 > n3) continue;
            n4 = graphicPrimitive.getLayer();
            if (!vector.get((int)n4).isVisible) continue;
            n3 = n5;
        }
        return n3;
    }

    public void handleSelection(MapCoordinates mapCoordinates, int n, int n2, boolean bl) {
        int n3;
        if (!bl) {
            this.sa.setSelectionAll(false);
        }
        if ((n3 = mapCoordinates.unmapXnosnap(n + this.sel_tolerance) - mapCoordinates.unmapXnosnap(n)) < 2) {
            n3 = 2;
        }
        this.selectPrimitive(mapCoordinates.unmapXnosnap(n), mapCoordinates.unmapYnosnap(n2), n3, bl);
    }

    private boolean selectPrimitive(int n, int n2, int n3, boolean bl) {
        int n4 = Integer.MAX_VALUE;
        GraphicPrimitive graphicPrimitive = null;
        Vector<LayerDesc> vector = this.dmp.getLayers();
        for (GraphicPrimitive graphicPrimitive2 : this.dmp.getPrimitiveVector()) {
            int n5;
            int n6 = graphicPrimitive2.getLayer();
            if (!vector.get((int)n6).isVisible && !(graphicPrimitive2 instanceof PrimitiveMacro) || (n5 = graphicPrimitive2.getDistanceToPoint(n, n2)) > n4) continue;
            graphicPrimitive = graphicPrimitive2;
            n4 = n5;
        }
        if (n4 < n3 && graphicPrimitive != null) {
            if (bl) {
                graphicPrimitive.setSelected(!graphicPrimitive.getSelected());
            } else {
                graphicPrimitive.setSelected(true);
            }
            return true;
        }
        return false;
    }

    public boolean selectRect(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n3 < 1 || n4 < 1) {
            return false;
        }
        Vector<LayerDesc> vector = this.dmp.getLayers();
        for (GraphicPrimitive graphicPrimitive : this.dmp.getPrimitiveVector()) {
            int n5 = graphicPrimitive.getLayer();
            if (n5 < vector.size() && !vector.get((int)n5).isVisible && !(graphicPrimitive instanceof PrimitiveMacro) || !graphicPrimitive.selectRect(n, n2, n3, n4)) continue;
            bl = true;
        }
        return bl;
    }
}

