/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.globals.ProvidesCopyPasteInterface;

public class CopyPasteActions {
    private final DrawingModel dmp;
    private final EditorActions edt;
    private final ParserActions pa;
    private final UndoActions ua;
    private final SelectionActions sa;
    private final ProvidesCopyPasteInterface cpi;
    private boolean shiftCP;

    public CopyPasteActions(DrawingModel drawingModel, EditorActions editorActions, SelectionActions selectionActions, ParserActions parserActions, UndoActions undoActions, ProvidesCopyPasteInterface providesCopyPasteInterface) {
        this.dmp = drawingModel;
        this.edt = editorActions;
        this.pa = parserActions;
        this.sa = selectionActions;
        this.ua = undoActions;
        this.cpi = providesCopyPasteInterface;
        this.shiftCP = false;
    }

    public void paste(int n, int n2) {
        this.sa.setSelectionAll(false);
        try {
            this.pa.addString(new StringBuffer(this.cpi.pasteText()), true);
        }
        catch (Exception exception) {
            System.out.println("Warning: paste operation has gone wrong.");
        }
        if (this.shiftCP) {
            this.edt.moveAllSelected(n, n2);
        }
        this.ua.saveUndoState();
        this.dmp.setChanged(true);
    }

    public void copySelected(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = this.sa.getSelectedString(bl, this.pa);
        if (bl2) {
            stringBuffer = this.pa.splitMacros(stringBuffer, false);
        }
        this.cpi.copyText(stringBuffer.toString());
    }

    public boolean getShiftCopyPaste() {
        return this.shiftCP;
    }

    public void setShiftCopyPaste(boolean bl) {
        this.shiftCP = bl;
    }
}

