/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import java.io.IOException;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.ElementsEdtActions;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.geom.ChangeCoordinatesListener;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.layers.StandardLayers;
import net.sourceforge.fidocadj.primitives.PrimitiveComplexCurve;
import net.sourceforge.fidocadj.primitives.PrimitiveLine;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;
import net.sourceforge.fidocadj.primitives.PrimitiveOval;
import net.sourceforge.fidocadj.primitives.PrimitivePCBLine;
import net.sourceforge.fidocadj.primitives.PrimitivePolygon;
import net.sourceforge.fidocadj.primitives.PrimitiveRectangle;

public class ContinuosMoveActions
extends ElementsEdtActions {
    private ChangeCoordinatesListener coordinatesListener = null;
    private int oldx = -1;
    private int oldy = -1;

    public ContinuosMoveActions(DrawingModel drawingModel, SelectionActions selectionActions, UndoActions undoActions, EditorActions editorActions) {
        super(drawingModel, selectionActions, undoActions, editorActions);
    }

    public void addChangeCoordinatesListener(ChangeCoordinatesListener changeCoordinatesListener) {
        this.coordinatesListener = changeCoordinatesListener;
    }

    public boolean continuosMove(MapCoordinates mapCoordinates, int n, int n2, boolean bl) {
        int n3 = mapCoordinates.mapX(mapCoordinates.unmapXsnap(n), 0.0);
        int n4 = mapCoordinates.mapY(0.0, mapCoordinates.unmapYsnap(n2));
        if (this.oldx == n3 && this.oldy == n4) {
            return false;
        }
        this.oldx = n3;
        this.oldy = n4;
        if (this.coordinatesListener != null) {
            this.coordinatesListener.changeCoordinates(mapCoordinates.unmapXsnap(n), mapCoordinates.unmapYsnap(n2));
        }
        boolean bl2 = false;
        if (this.actionSelected != 13) {
            this.primEdit = null;
        }
        if (this.actionSelected == 13) {
            try {
                int n5 = 0;
                boolean bl3 = false;
                if (this.primEdit instanceof PrimitiveMacro) {
                    n5 = ((PrimitiveMacro)this.primEdit).getOrientation();
                    bl3 = ((PrimitiveMacro)this.primEdit).isMirrored();
                }
                PrimitiveMacro primitiveMacro = new PrimitiveMacro(this.dmp.getLibrary(), StandardLayers.createEditingLayerArray(), mapCoordinates.unmapXsnap(n3), mapCoordinates.unmapYsnap(n4), this.macroKey, "", mapCoordinates.unmapXsnap(n3) + 10, mapCoordinates.unmapYsnap(n4) + 5, "", mapCoordinates.unmapXsnap(n3) + 10, mapCoordinates.unmapYsnap(n4) + 10, this.dmp.getTextFont(), this.dmp.getTextFontSize(), n5, bl3);
                primitiveMacro.setDrawOnlyLayer(-1);
                this.primEdit = primitiveMacro;
                bl2 = true;
                this.successiveMove = true;
            }
            catch (IOException iOException) {
                System.out.println("Warning: exception while handling macro: " + iOException);
            }
        }
        if (this.clickNumber == 0) {
            return bl2;
        }
        if (this.actionSelected == 4) {
            this.primEdit = new PrimitiveLine(this.xpoly[1], this.ypoly[1], mapCoordinates.unmapXsnap(n3), mapCoordinates.unmapYsnap(n4), 0, false, false, 0, 3, 2, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            bl2 = true;
            this.successiveMove = true;
            if (this.coordinatesListener != null) {
                double d = Math.sqrt((this.xpoly[1] - mapCoordinates.unmapXsnap(n)) * (this.xpoly[1] - mapCoordinates.unmapXsnap(n)) + (this.ypoly[1] - mapCoordinates.unmapYsnap(n2)) * (this.ypoly[1] - mapCoordinates.unmapYsnap(n2)));
                double d2 = d * 127.0 / 1000.0;
                this.coordinatesListener.changeInfos(Globals.messages.getString("length") + Globals.roundTo(d, 2) + " (" + Globals.roundTo(d2, 2) + " mm)");
            }
        }
        if (this.actionSelected == 11) {
            this.primEdit = new PrimitivePCBLine(this.xpoly[1], this.ypoly[1], mapCoordinates.unmapXsnap(n3), mapCoordinates.unmapYsnap(n4), this.ae.getPCB_thickness(), 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            bl2 = true;
            this.successiveMove = true;
            if (this.coordinatesListener != null) {
                double d = Math.sqrt((this.xpoly[1] - mapCoordinates.unmapXsnap(n)) * (this.xpoly[1] - mapCoordinates.unmapXsnap(n)) + (this.ypoly[1] - mapCoordinates.unmapYsnap(n2)) * (this.ypoly[1] - mapCoordinates.unmapYsnap(n2)));
                this.coordinatesListener.changeInfos(Globals.messages.getString("length") + Globals.roundTo(d, 2));
            }
        }
        if (this.actionSelected == 6) {
            this.primEdit = new PrimitivePolygon(false, 0, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            for (int i = 1; i <= this.clickNumber; ++i) {
                ((PrimitivePolygon)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitivePolygon)this.primEdit).addPoint(mapCoordinates.unmapXsnap(n3), mapCoordinates.unmapYsnap(n4));
            bl2 = true;
            this.successiveMove = true;
        }
        if (this.actionSelected == 7) {
            this.primEdit = new PrimitivePolygon(false, 0, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            for (int i = 1; i <= this.clickNumber && i < 256; ++i) {
                ((PrimitivePolygon)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitivePolygon)this.primEdit).addPoint(mapCoordinates.unmapXsnap(n3), mapCoordinates.unmapYsnap(n4));
            bl2 = true;
            this.successiveMove = true;
        }
        if (this.actionSelected == 14) {
            this.primEdit = new PrimitiveComplexCurve(false, false, 0, false, false, 0, 3, 2, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            for (int i = 1; i <= this.clickNumber && i < 256; ++i) {
                ((PrimitiveComplexCurve)this.primEdit).addPoint(this.xpoly[i], this.ypoly[i]);
            }
            ((PrimitiveComplexCurve)this.primEdit).addPoint(mapCoordinates.unmapXsnap(n3), mapCoordinates.unmapYsnap(n4));
            bl2 = true;
            this.successiveMove = true;
        }
        if (this.actionSelected == 9) {
            int n6 = bl && this.clickNumber > 0 ? mapCoordinates.mapY(this.xpoly[1], this.ypoly[1]) + n3 - mapCoordinates.mapX(this.xpoly[1], this.ypoly[1]) : n4;
            this.primEdit = new PrimitiveRectangle(this.xpoly[1], this.ypoly[1], mapCoordinates.unmapXsnap(n3), mapCoordinates.unmapYsnap(n6), false, 0, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            bl2 = true;
            this.successiveMove = true;
        }
        if (this.actionSelected == 8) {
            int n7 = bl && this.clickNumber > 0 ? mapCoordinates.mapY(this.xpoly[1], this.ypoly[1]) + n3 - mapCoordinates.mapX(this.xpoly[1], this.ypoly[1]) : n4;
            this.primEdit = new PrimitiveOval(this.xpoly[1], this.ypoly[1], mapCoordinates.unmapXsnap(n3), mapCoordinates.unmapYsnap(n7), false, 0, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            bl2 = true;
            this.successiveMove = true;
        }
        return bl2;
    }
}

