/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit.controllers;

import java.io.IOException;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.PrimitiveBezier;
import net.sourceforge.fidocadj.primitives.PrimitiveConnection;
import net.sourceforge.fidocadj.primitives.PrimitiveLine;
import net.sourceforge.fidocadj.primitives.PrimitiveMacro;
import net.sourceforge.fidocadj.primitives.PrimitiveOval;
import net.sourceforge.fidocadj.primitives.PrimitivePCBLine;
import net.sourceforge.fidocadj.primitives.PrimitivePCBPad;
import net.sourceforge.fidocadj.primitives.PrimitiveRectangle;

public class AddElements {
    private final DrawingModel dmp;
    private final UndoActions ua;
    public int pcbPadSizeX;
    public int pcbPadSizeY;
    public int pcbPadStyle;
    public int pcbPadDrill;
    public int pcbThickness;

    public AddElements(DrawingModel drawingModel, UndoActions undoActions) {
        this.dmp = drawingModel;
        this.ua = undoActions;
        this.pcbThickness = 5;
        this.pcbPadSizeX = 5;
        this.pcbPadSizeY = 5;
        this.pcbPadDrill = 2;
    }

    public void setPCB_pad_sizex(int n) {
        this.pcbPadSizeX = n;
    }

    public int getPCB_pad_sizex() {
        return this.pcbPadSizeX;
    }

    public void setPCB_pad_sizey(int n) {
        this.pcbPadSizeY = n;
    }

    public int getPCB_pad_sizey() {
        return this.pcbPadSizeY;
    }

    public void setPCB_pad_style(int n) {
        this.pcbPadStyle = n;
    }

    public int getPCB_pad_style() {
        return this.pcbPadStyle;
    }

    public void setPCB_pad_drill(int n) {
        this.pcbPadDrill = n;
    }

    public int getPCB_pad_drill() {
        return this.pcbPadDrill;
    }

    public void setPCB_thickness(int n) {
        this.pcbThickness = n;
    }

    public int getPCB_thickness() {
        return this.pcbThickness;
    }

    public void addConnection(int n, int n2, int n3) {
        PrimitiveConnection primitiveConnection = new PrimitiveConnection(n, n2, n3, this.dmp.getTextFont(), this.dmp.getTextFontSize());
        primitiveConnection.setMacroFont(this.dmp.getTextFont(), this.dmp.getTextFontSize());
        this.dmp.addPrimitive(primitiveConnection, true, this.ua);
    }

    public int addLine(int n, int n2, int[] nArray, int[] nArray2, int n3, int n4, boolean bl) {
        int n5 = n4;
        nArray[n4] = n;
        nArray2[n4] = n2;
        if (n4 == 2 || bl) {
            PrimitiveLine primitiveLine = new PrimitiveLine(nArray[1], nArray2[1], nArray[2], nArray2[2], n3, false, false, 0, 3, 2, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            this.dmp.addPrimitive(primitiveLine, true, this.ua);
            if (bl) {
                n5 = 0;
            } else {
                n5 = 1;
                nArray[1] = nArray[2];
                nArray2[1] = nArray2[2];
            }
        }
        return n5;
    }

    public GraphicPrimitive addMacro(int n, int n2, SelectionActions selectionActions, GraphicPrimitive graphicPrimitive, String string) {
        GraphicPrimitive graphicPrimitive2 = graphicPrimitive;
        try {
            selectionActions.setSelectionAll(false);
            int n3 = 0;
            boolean bl = false;
            if (graphicPrimitive2 instanceof PrimitiveMacro) {
                n3 = ((PrimitiveMacro)graphicPrimitive2).getOrientation();
                bl = ((PrimitiveMacro)graphicPrimitive2).isMirrored();
            }
            this.dmp.addPrimitive(new PrimitiveMacro(this.dmp.getLibrary(), this.dmp.getLayers(), n, n2, string, "", n + 10, n2 + 5, "", n + 10, n2 + 10, this.dmp.getTextFont(), this.dmp.getTextFontSize(), n3, bl), true, this.ua);
            graphicPrimitive2 = null;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return graphicPrimitive2;
    }

    public int addEllipse(int n, int n2, int[] nArray, int[] nArray2, int n3, int n4, boolean bl) {
        int n5 = n2;
        int n6 = n4;
        if (bl) {
            n5 = nArray2[1] + n - nArray[1];
        }
        nArray[n4] = n;
        nArray2[n4] = n5;
        if (n6 == 2) {
            PrimitiveOval primitiveOval = new PrimitiveOval(nArray[1], nArray2[1], nArray[2], nArray2[2], false, n3, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            this.dmp.addPrimitive(primitiveOval, true, this.ua);
            n6 = 0;
        }
        return n6;
    }

    public int addBezier(int n, int n2, int[] nArray, int[] nArray2, int n3, int n4) {
        int n5 = n4;
        nArray[n4] = n;
        nArray2[n4] = n2;
        if (n4 == 4) {
            PrimitiveBezier primitiveBezier = new PrimitiveBezier(nArray[1], nArray2[1], nArray[2], nArray2[2], nArray[3], nArray2[3], nArray[4], nArray2[4], n3, false, false, 0, 3, 2, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            this.dmp.addPrimitive(primitiveBezier, true, this.ua);
            n5 = 0;
        }
        return n5;
    }

    public int addRectangle(int n, int n2, int[] nArray, int[] nArray2, int n3, int n4, boolean bl) {
        int n5 = n2;
        int n6 = n4;
        if (bl) {
            n5 = nArray2[1] + n - nArray[1];
        }
        nArray[n4] = n;
        nArray2[n4] = n5;
        if (n6 == 2) {
            PrimitiveRectangle primitiveRectangle = new PrimitiveRectangle(nArray[1], nArray2[1], nArray[2], nArray2[2], false, n3, 0, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            this.dmp.addPrimitive(primitiveRectangle, true, this.ua);
            n6 = 0;
        }
        if (n6 >= 2) {
            n6 = 0;
        }
        return n6;
    }

    public int addPCBLine(int n, int n2, int[] nArray, int[] nArray2, int n3, int n4, boolean bl, float f) {
        int n5 = n4;
        nArray[n5] = n;
        nArray2[n5] = n2;
        if (n5 == 2 || bl) {
            PrimitivePCBLine primitivePCBLine = new PrimitivePCBLine(nArray[1], nArray2[1], nArray[2], nArray2[2], f, n3, this.dmp.getTextFont(), this.dmp.getTextFontSize());
            this.dmp.addPrimitive(primitivePCBLine, true, this.ua);
            if (bl) {
                n5 = 0;
            } else {
                n5 = 1;
                nArray[1] = nArray[2];
                nArray2[1] = nArray2[2];
            }
        }
        return n5;
    }

    public void addPCBPad(int n, int n2, int n3) {
        PrimitivePCBPad primitivePCBPad = new PrimitivePCBPad(n, n2, this.pcbPadSizeX, this.pcbPadSizeY, this.pcbPadDrill, this.pcbPadStyle, n3, this.dmp.getTextFont(), this.dmp.getTextFontSize());
        this.dmp.addPrimitive(primitivePCBPad, true, this.ua);
    }
}

