/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;

public class Ruler {
    private static final String rulerFont = "Lucida Sans Regular";
    private final Color rulerColor;
    private final Color textColor;
    private int rulerStartX;
    private int rulerStartY;
    private int rulerEndX;
    private int rulerEndY;
    private boolean isActiveRuler;

    public Ruler(Color color, Color color2) {
        this.rulerColor = color;
        this.textColor = color2;
        this.isActiveRuler = false;
    }

    public void setActive(boolean bl) {
        this.isActiveRuler = bl;
    }

    public boolean isActive() {
        return this.isActiveRuler;
    }

    public void drawRuler(Graphics graphics, MapCoordinates mapCoordinates) {
        if (!this.isActiveRuler) {
            return;
        }
        int n = this.rulerStartX;
        int n2 = this.rulerStartY;
        int n3 = this.rulerEndX;
        int n4 = this.rulerEndY;
        int n5 = mapCoordinates.unmapXnosnap(n);
        int n6 = mapCoordinates.unmapYnosnap(n2);
        int n7 = mapCoordinates.unmapXnosnap(n3);
        int n8 = mapCoordinates.unmapYnosnap(n4);
        double d = Math.sqrt((double)(n5 - n7) * (double)(n5 - n7) + (double)((n6 - n8) * (n6 - n8)));
        graphics.drawLine(n, n2, n3, n4);
        double d2 = n == n3 ? 1.5707963267948966 + (n4 - n2 < 0 ? 0.0 : Math.PI) : Math.atan((double)(n4 - n2) / (double)(n3 - n));
        d2 += n3 - n > 0 ? 0.0 : Math.PI;
        double d3 = 5.0;
        d3 = mapCoordinates.getXMagnitude() < 1.0 ? 10.0 : (mapCoordinates.getXMagnitude() > 5.0 ? 1.0 : 5.0);
        double d4 = 0.0;
        double d5 = 5.0;
        int n9 = 5;
        int n10 = 0;
        double d6 = (double)n + d * Math.cos(d2) * mapCoordinates.getXMagnitude();
        double d7 = (double)n2 + d * Math.sin(d2) * mapCoordinates.getYMagnitude();
        d2 += 1.5707963267948966;
        boolean bl = true;
        for (double d8 = 0.0; d8 <= d; d8 += d3) {
            if (n10++ == n9 || bl) {
                n10 = 1;
                d4 = 2.0 * d5;
                bl = false;
            } else {
                d4 = d5;
            }
            double d9 = d6 * d8 / d + (double)n * (d - d8) / d;
            double d10 = d7 * d8 / d + (double)n2 * (d - d8) / d;
            int n11 = (int)(d9 - d4 * Math.cos(d2));
            int n12 = (int)(d9 + d4 * Math.cos(d2));
            int n13 = (int)(d10 - d4 * Math.sin(d2));
            int n14 = (int)(d10 + d4 * Math.sin(d2));
            graphics.drawLine(n11, n13, n12, n14);
        }
        Font font = new Font(rulerFont, 0, 10);
        graphics.setFont(font);
        String string = Globals.roundTo(d, 2);
        String string2 = Globals.roundTo(d * 0.127, 2) + " mm";
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setColor(Color.white);
        graphics.fillRect(n3 + 10, n4, Math.max(fontMetrics.stringWidth(string), fontMetrics.stringWidth(string2)) + 1, 24);
        graphics.setColor(this.rulerColor);
        graphics.drawRect(n3 + 9, n4 - 1, Math.max(fontMetrics.stringWidth(string), fontMetrics.stringWidth(string2)) + 2, 25);
        graphics.setColor(this.textColor);
        graphics.drawString(string, n3 + 10, n4 + 10);
        graphics.drawString(string2, n3 + 10, n4 + 20);
    }

    public void setRulerStart(int n, int n2) {
        this.rulerStartX = n;
        this.rulerStartY = n2;
    }

    public void setRulerEnd(int n, int n2) {
        this.rulerEndX = n;
        this.rulerEndY = n2;
    }

    public int getRulerStartX() {
        return this.rulerStartX;
    }

    public int getRulerStartY() {
        return this.rulerStartY;
    }
}

