/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.circuit.controllers.ContinuosMoveActions;
import net.sourceforge.fidocadj.circuit.controllers.CopyPasteActions;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.clipboard.TextTransfer;
import net.sourceforge.fidocadj.dialogs.DialogSymbolize;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.globals.LibUtils;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.primitives.PrimitiveComplexCurve;
import net.sourceforge.fidocadj.primitives.PrimitivePolygon;

public class PopUpMenu
implements ActionListener {
    private JMenuItem editProperties;
    private JMenuItem editCut;
    private JMenuItem editCopy;
    private JMenuItem editPaste;
    private JMenuItem editDuplicate;
    private JMenuItem editSelectAll;
    private JMenuItem editRotate;
    private JMenuItem editMirror;
    private JMenuItem editSymbolize;
    private JMenuItem editUSymbolize;
    private JMenuItem editAddNode;
    private JMenuItem editRemoveNode;
    private final CircuitPanel cp;
    private final SelectionActions sa;
    private final EditorActions edt;
    private final ContinuosMoveActions eea;
    private final UndoActions ua;
    private final ParserActions pa;
    private final CopyPasteActions cpa;
    private final JPopupMenu pp;
    private int menux;
    private int menuy;

    public PopUpMenu(CircuitPanel circuitPanel) {
        this.cp = circuitPanel;
        this.sa = this.cp.getSelectionActions();
        this.edt = this.cp.getEditorActions();
        this.eea = this.cp.getContinuosMoveActions();
        this.ua = this.cp.getUndoActions();
        this.pa = this.cp.getParserActions();
        this.cpa = this.cp.getCopyPasteActions();
        this.pp = new JPopupMenu();
        this.definePopupMenu();
    }

    public int getMenuX() {
        return this.menux;
    }

    public int getMenuY() {
        return this.menuy;
    }

    private void definePopupMenu() {
        this.editProperties = new JMenuItem(Globals.messages.getString("Param_opt"));
        this.editCut = new JMenuItem(Globals.messages.getString("Cut"));
        this.editCopy = new JMenuItem(Globals.messages.getString("Copy"));
        this.editSelectAll = new JMenuItem(Globals.messages.getString("SelectAll"));
        this.editPaste = new JMenuItem(Globals.messages.getString("Paste"));
        this.editDuplicate = new JMenuItem(Globals.messages.getString("Duplicate"));
        this.editRotate = new JMenuItem(Globals.messages.getString("Rotate"));
        this.editMirror = new JMenuItem(Globals.messages.getString("Mirror_E"));
        this.editSymbolize = new JMenuItem(Globals.messages.getString("Symbolize"));
        this.editUSymbolize = new JMenuItem(Globals.messages.getString("Unsymbolize"));
        this.editAddNode = new JMenuItem(Globals.messages.getString("Add_node"));
        this.editRemoveNode = new JMenuItem(Globals.messages.getString("Remove_node"));
        this.pp.add(this.editProperties);
        this.pp.addSeparator();
        this.pp.add(this.editCut);
        this.pp.add(this.editCopy);
        this.pp.add(this.editPaste);
        this.pp.add(this.editDuplicate);
        this.pp.addSeparator();
        this.pp.add(this.editSelectAll);
        this.pp.addSeparator();
        this.pp.add(this.editRotate);
        this.pp.add(this.editMirror);
        this.pp.add(this.editAddNode);
        this.pp.add(this.editRemoveNode);
        this.pp.addSeparator();
        this.pp.add(this.editSymbolize);
        this.pp.add(this.editUSymbolize);
        this.editProperties.addActionListener(this);
        this.editCut.addActionListener(this);
        this.editCopy.addActionListener(this);
        this.editSelectAll.addActionListener(this);
        this.editPaste.addActionListener(this);
        this.editDuplicate.addActionListener(this);
        this.editRotate.addActionListener(this);
        this.editMirror.addActionListener(this);
        this.editAddNode.addActionListener(this);
        this.editRemoveNode.addActionListener(this);
        this.editSymbolize.addActionListener(this);
        this.editUSymbolize.addActionListener(this);
    }

    public void showPopUpMenu(JPanel jPanel, int n, int n2) {
        boolean bl;
        this.menux = n;
        this.menuy = n2;
        boolean bl2 = false;
        GraphicPrimitive graphicPrimitive = this.sa.getFirstSelectedPrimitive();
        bl2 = bl = graphicPrimitive != null;
        this.editProperties.setEnabled(bl2);
        this.editCut.setEnabled(bl2);
        this.editCopy.setEnabled(bl2);
        this.editRotate.setEnabled(bl2);
        this.editMirror.setEnabled(bl2);
        this.editDuplicate.setEnabled(bl2);
        this.editSelectAll.setEnabled(true);
        bl2 = graphicPrimitive instanceof PrimitiveComplexCurve || graphicPrimitive instanceof PrimitivePolygon;
        if (!this.sa.isUniquePrimitiveSelected()) {
            bl2 = false;
        }
        this.editAddNode.setEnabled(bl2);
        this.editRemoveNode.setEnabled(bl2);
        this.editAddNode.setVisible(bl2);
        this.editRemoveNode.setVisible(bl2);
        TextTransfer textTransfer = new TextTransfer();
        if (textTransfer.getClipboardContents().equals("")) {
            this.editPaste.setEnabled(false);
        } else {
            this.editPaste.setEnabled(true);
        }
        this.editSymbolize.setEnabled(bl);
        this.editUSymbolize.setEnabled(this.sa.selectionCanBeSplitted());
        this.pp.show(jPanel, n, n2);
    }

    private void registerAction(String string, char c, final int n) {
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke(Character.toUpperCase(c)), string);
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke(Character.toLowerCase(c)), string);
        this.cp.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopUpMenu.this.cp.setSelectionState(n, "");
                ((PopUpMenu)PopUpMenu.this).eea.primEdit = null;
                PopUpMenu.this.cp.repaint();
            }
        });
    }

    public final void registerActiveKeys() {
        this.registerAction("selection", 'a', 1);
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0, false), "selection");
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "selection");
        this.registerAction("line", 'l', 4);
        this.registerAction("text", 't', 5);
        this.registerAction("bezier", 'b', 6);
        this.registerAction("polygon", 'p', 7);
        this.registerAction("complexcurve", 'o', 14);
        this.registerAction("ellipse", 'e', 8);
        this.registerAction("rectangle", 'g', 9);
        this.registerAction("connection", 'c', 10);
        this.registerAction("pcbline", 'i', 11);
        this.registerAction("pcbpad", 'z', 12);
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke("BACK_SPACE"), "delete");
        this.cp.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopUpMenu.this.edt.deleteAllSelected(true);
                PopUpMenu.this.cp.repaint();
            }
        });
        this.cp.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((PopUpMenu)PopUpMenu.this).eea.clickNumber > 0) {
                    ((PopUpMenu)PopUpMenu.this).eea.successiveMove = false;
                    ((PopUpMenu)PopUpMenu.this).eea.clickNumber = 0;
                    ((PopUpMenu)PopUpMenu.this).eea.primEdit = null;
                    PopUpMenu.this.cp.repaint();
                }
            }
        });
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke(37, 8, false), "lleft");
        this.cp.getActionMap().put("lleft", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopUpMenu.this.edt.moveAllSelected(-1, 0);
                PopUpMenu.this.cp.repaint();
            }
        });
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke(39, 8, false), "lright");
        this.cp.getActionMap().put("lright", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopUpMenu.this.edt.moveAllSelected(1, 0);
                PopUpMenu.this.cp.repaint();
            }
        });
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke(38, 8, false), "lup");
        this.cp.getActionMap().put("lup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopUpMenu.this.edt.moveAllSelected(0, -1);
                PopUpMenu.this.cp.repaint();
            }
        });
        this.cp.getInputMap(2).put(KeyStroke.getKeyStroke(40, 8, false), "ldown");
        this.cp.getActionMap().put("ldown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopUpMenu.this.edt.moveAllSelected(0, 1);
                PopUpMenu.this.cp.repaint();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            if (string.equals(Globals.messages.getString("Param_opt"))) {
                this.cp.setPropertiesForPrimitive();
            } else if (string.equals(Globals.messages.getString("Copy"))) {
                this.cpa.copySelected(!this.cp.getStrictCompatibility(), false);
            } else if (string.equals(Globals.messages.getString("Cut"))) {
                this.cpa.copySelected(!this.cp.getStrictCompatibility(), false);
                this.edt.deleteAllSelected(true);
                this.cp.repaint();
            } else if (string.equals(Globals.messages.getString("Paste"))) {
                this.cpa.paste(this.cp.getMapCoordinates().getXGridStep(), this.cp.getMapCoordinates().getYGridStep());
                this.cp.repaint();
            } else if (string.equals(Globals.messages.getString("Duplicate"))) {
                this.cpa.copySelected(!this.cp.getStrictCompatibility(), false);
                this.cpa.paste(this.cp.getMapCoordinates().getXGridStep(), this.cp.getMapCoordinates().getYGridStep());
                this.cp.repaint();
            } else if (string.equals(Globals.messages.getString("SelectAll"))) {
                this.sa.setSelectionAll(true);
                this.cp.repaint();
            } else if (string.equals(Globals.messages.getString("Rotate"))) {
                if (this.eea.isEnteringMacro()) {
                    this.eea.rotateMacro();
                } else {
                    this.edt.rotateAllSelected();
                }
                this.cp.repaint();
            } else if (string.equals(Globals.messages.getString("Mirror_E"))) {
                if (this.eea.isEnteringMacro()) {
                    this.eea.mirrorMacro();
                } else {
                    this.edt.mirrorAllSelected();
                }
                this.cp.repaint();
            } else if (string.equals(Globals.messages.getString("Symbolize"))) {
                if (this.sa.getFirstSelectedPrimitive() == null) {
                    return;
                }
                DialogSymbolize dialogSymbolize = new DialogSymbolize(this.cp, this.cp.getDrawingModel());
                dialogSymbolize.setModal(true);
                dialogSymbolize.setVisible(true);
                try {
                    LibUtils.saveLibraryState(this.ua);
                }
                catch (IOException iOException) {
                    System.out.println("Exception: " + iOException);
                }
                this.cp.repaint();
            } else if (string.equals(Globals.messages.getString("Unsymbolize"))) {
                StringBuffer stringBuffer = this.sa.getSelectedString(true, this.pa);
                this.edt.deleteAllSelected(false);
                this.pa.addString(this.pa.splitMacros(stringBuffer, true), true);
                this.ua.saveUndoState();
                this.cp.repaint();
            } else if (string.equals(Globals.messages.getString("Remove_node"))) {
                if (this.sa.getFirstSelectedPrimitive() instanceof PrimitivePolygon) {
                    PrimitivePolygon primitivePolygon = (PrimitivePolygon)this.sa.getFirstSelectedPrimitive();
                    primitivePolygon.removePoint(this.cp.getMapCoordinates().unmapXnosnap(this.getMenuX()), this.cp.getMapCoordinates().unmapYnosnap(this.getMenuY()), 1.0);
                    this.ua.saveUndoState();
                    this.cp.repaint();
                } else if (this.sa.getFirstSelectedPrimitive() instanceof PrimitiveComplexCurve) {
                    PrimitiveComplexCurve primitiveComplexCurve = (PrimitiveComplexCurve)this.sa.getFirstSelectedPrimitive();
                    primitiveComplexCurve.removePoint(this.cp.getMapCoordinates().unmapXnosnap(this.getMenuX()), this.cp.getMapCoordinates().unmapYnosnap(this.getMenuY()), 1.0);
                    this.ua.saveUndoState();
                    this.cp.repaint();
                }
            } else if (string.equals(Globals.messages.getString("Add_node"))) {
                if (this.sa.getFirstSelectedPrimitive() instanceof PrimitivePolygon) {
                    PrimitivePolygon primitivePolygon = (PrimitivePolygon)this.sa.getFirstSelectedPrimitive();
                    primitivePolygon.addPointClosest(this.cp.getMapCoordinates().unmapXsnap(this.getMenuX()), this.cp.getMapCoordinates().unmapYsnap(this.getMenuY()));
                    this.ua.saveUndoState();
                    this.cp.repaint();
                } else if (this.sa.getFirstSelectedPrimitive() instanceof PrimitiveComplexCurve) {
                    PrimitiveComplexCurve primitiveComplexCurve = (PrimitiveComplexCurve)this.sa.getFirstSelectedPrimitive();
                    primitiveComplexCurve.addPointClosest(this.cp.getMapCoordinates().unmapXsnap(this.getMenuX()), this.cp.getMapCoordinates().unmapYsnap(this.getMenuY()));
                    this.ua.saveUndoState();
                    this.cp.repaint();
                }
            }
        }
    }
}

