/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.globals.Globals;

public class MouseWheelHandler
implements KeyListener,
MouseWheelListener {
    CircuitPanel cc;

    public MouseWheelHandler(CircuitPanel circuitPanel) {
        this.cc = circuitPanel;
    }

    private int getKeyForWheel() {
        int n = 17;
        if (Globals.weAreOnAMac) {
            n = 157;
        }
        return n;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == this.getKeyForWheel() && !this.hasMouseWheelListener()) {
            this.cc.addMouseWheelListener(this);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == this.getKeyForWheel() && this.hasMouseWheelListener()) {
            this.cc.removeMouseWheelListener(this);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private boolean hasMouseWheelListener() {
        MouseWheelListener[] mouseWheelListenerArray;
        for (MouseWheelListener mouseWheelListener : mouseWheelListenerArray = this.cc.getMouseWheelListeners()) {
            if (!mouseWheelListener.equals(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.cc.changeZoomByStep(mouseWheelEvent.getWheelRotation() < 0, mouseWheelEvent.getX(), mouseWheelEvent.getY(), 1.1);
    }
}

