/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.circuit.controllers.ContinuosMoveActions;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.HandleActions;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.timer.MyTimer;

public class MouseMoveClickHandler
implements MouseMotionListener,
MouseListener {
    private final CircuitPanel cp;
    private final EditorActions edt;
    private final ContinuosMoveActions eea;
    private final HandleActions haa;
    private double record_c;
    private double record_d;

    public MouseMoveClickHandler(CircuitPanel circuitPanel) {
        this.cp = circuitPanel;
        this.edt = this.cp.getEditorActions();
        this.eea = this.cp.getContinuosMoveActions();
        this.haa = new HandleActions(this.cp.getDrawingModel(), this.edt, this.cp.getSelectionActions(), this.cp.getUndoActions());
        this.record_d = 1.0E100;
        this.record_c = 1.0E100;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.cp.requestFocusInWindow();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = this.getToggle(mouseEvent);
        if (this.eea.continuosMove(this.cp.getMapCoordinates(), n, n2, bl)) {
            this.cp.repaint();
        }
    }

    private boolean getToggle(MouseEvent mouseEvent) {
        if (Globals.useMetaForMultipleSelection) {
            return mouseEvent.isMetaDown();
        }
        return mouseEvent.isControlDown();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        MyTimer myTimer = new MyTimer();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.cp.getRuler().setActive(false);
        this.cp.getRuler().setRulerStart(n, n2);
        this.cp.getRuler().setRulerEnd(n, n2);
        boolean bl = this.getToggle(mouseEvent);
        if (this.eea.actionSelected == 1 && (mouseEvent.getModifiers() & 4) == 0 && !mouseEvent.isShiftDown()) {
            this.haa.dragHandleStart(n, n2, this.edt.getSelectionTolerance(), bl, this.cp.getMapCoordinates());
        } else if (this.eea.actionSelected == 1) {
            this.cp.getRuler().setActive(true);
        }
        if (this.cp.isProfiling()) {
            double d = myTimer.getElapsed();
            if (d < this.record_c) {
                this.record_c = d;
            }
            System.out.println("MP: Time elapsed: " + d + "; record: " + this.record_c + " ms");
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        MyTimer myTimer = new MyTimer();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 4) != 0 || mouseEvent.isShiftDown()) {
            this.cp.getRuler().setRulerEnd(n, n2);
            this.cp.repaint();
            return;
        }
        this.haa.dragHandleDrag(this.cp, n, n2, this.cp.getMapCoordinates(), (mouseEvent.getModifiers() & 2) == 2);
        if (this.cp.isProfiling()) {
            double d = myTimer.getElapsed();
            if (d < this.record_d) {
                this.record_d = d;
            }
            System.out.println("MD: Time elapsed: " + d + "; record: " + this.record_d + " ms");
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        MyTimer myTimer = new MyTimer();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        MapCoordinates mapCoordinates = this.cp.getMapCoordinates();
        boolean bl = false;
        boolean bl2 = this.getToggle(mouseEvent);
        if (Globals.weAreOnAMac) {
            if (mouseEvent.getButton() == 3) {
                bl = true;
            } else if (mouseEvent.getButton() == 1 && mouseEvent.isControlDown()) {
                bl = true;
            }
        } else {
            boolean bl3 = bl = (mouseEvent.getModifiers() & 4) == 4;
        }
        if (this.eea.actionSelected == 1) {
            if (this.cp.getRuler().getRulerStartX() != n || this.cp.getRuler().getRulerStartY() != n2) {
                this.haa.dragHandleEnd(this.cp, n, n2, bl2, mapCoordinates);
            } else {
                this.cp.getRuler().setActive(false);
                this.cp.requestFocusInWindow();
                this.eea.handleClick(mapCoordinates, mouseEvent.getX(), mouseEvent.getY(), bl, bl2, mouseEvent.getClickCount() >= 2);
            }
            this.cp.repaint();
        } else {
            this.cp.requestFocusInWindow();
            if (this.eea.handleClick(mapCoordinates, mouseEvent.getX(), mouseEvent.getY(), bl, bl2, mouseEvent.getClickCount() >= 2)) {
                this.cp.repaint();
            }
        }
        if (this.cp.isProfiling()) {
            double d = myTimer.getElapsed();
            if (d < this.record_d) {
                this.record_d = d;
            }
            System.out.println("MR: Time elapsed: " + d + "; record: " + this.record_d + " ms");
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.selectCursor();
    }

    public void selectCursor() {
        switch (this.eea.actionSelected) {
            case 0: 
            case 2: 
            case 3: {
                this.cp.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.cp.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            default: {
                this.cp.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.cp.setCursor(Cursor.getPredefinedCursor(0));
        if (this.eea.successiveMove) {
            this.eea.successiveMove = false;
            this.cp.repaint();
        }
    }
}

