/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.sourceforge.fidocadj.geom.MapCoordinates;

public class ImageAsCanvas {
    private BufferedImage img = null;
    private String filename;
    private BufferedImage resizedImg;
    private double resolution = 200.0;
    private double xcorner = 0.0;
    private double ycorner = 0.0;
    private int oldw = 0;
    private int oldh = 0;
    private int shiftx = 0;
    private int shifty = 0;
    private int maxResizedWidth;
    private int maxResizedHeight;

    public ImageAsCanvas() {
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.maxResizedWidth = dimension.width * 3;
            this.maxResizedHeight = dimension.height * 3;
        }
        catch (HeadlessException headlessException) {
            this.maxResizedWidth = 3000;
            this.maxResizedHeight = 3000;
        }
    }

    public void loadImage(String string) throws IOException {
        this.img = ImageIO.read(new File(string));
        this.filename = string;
    }

    public void loadImage(String string, BufferedImage bufferedImage) {
        this.img = bufferedImage;
        this.filename = string;
    }

    public void setResolution(double d) {
        this.resolution = d;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void removeImage() {
        this.img = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setCorner(double d, double d2) {
        this.xcorner = d;
        this.ycorner = d2;
    }

    public double getCornerX() {
        return this.xcorner;
    }

    public void trackExtremePoints(MapCoordinates mapCoordinates) {
        if (this.img == null) {
            return;
        }
        int n = mapCoordinates.mapXi(this.xcorner, this.ycorner, false);
        int n2 = mapCoordinates.mapYi(this.xcorner, this.ycorner, false);
        int n3 = (int)(200.0 * (double)this.img.getWidth() / this.resolution * mapCoordinates.getXMagnitude() + 0.5);
        int n4 = (int)(200.0 * (double)this.img.getHeight() / this.resolution * mapCoordinates.getYMagnitude() + 0.5);
        mapCoordinates.trackPoint(n, n2);
        mapCoordinates.trackPoint(n + n3, n2 + n4);
    }

    public double getCornerY() {
        return this.ycorner;
    }

    public void drawCanvasImage(Graphics2D graphics2D, MapCoordinates mapCoordinates) {
        if (this.img == null) {
            return;
        }
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = (int)(200.0 * (double)this.img.getWidth() / this.resolution * mapCoordinates.getXMagnitude() + 0.5);
        int n6 = (int)(200.0 * (double)this.img.getHeight() / this.resolution * mapCoordinates.getYMagnitude() + 0.5);
        int n7 = mapCoordinates.mapXi(this.xcorner, this.ycorner, false);
        int n8 = mapCoordinates.mapYi(this.xcorner, this.ycorner, false);
        n3 = Math.max(0, Math.min(n3, n5 - n + n7));
        n4 = Math.max(0, Math.min(n4, n6 - n2 + n7));
        n = Math.max(n7, n);
        n2 = Math.max(n8, n2);
        if (this.oldw != n5 || this.oldh != n6 || n < this.shiftx || n2 < this.shifty || n + n3 > this.shiftx + this.maxResizedWidth || n2 + n4 > this.shifty + this.maxResizedHeight) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.oldw = n5;
            this.oldh = n6;
            if (n5 < this.maxResizedWidth && n6 < this.maxResizedHeight) {
                this.shiftx = n7;
                this.shifty = n8;
                this.resizedImg = graphicsConfiguration.createCompatibleImage(n5, n6, 3);
                if (this.img.getWidth() / n5 > 5) {
                    System.out.print("Multistep reduction");
                    BufferedImage bufferedImage = this.img;
                    BufferedImage bufferedImage2 = this.img;
                    int n9 = this.img.getWidth();
                    int n10 = this.img.getHeight();
                    while (n9 > n5 * 2) {
                        System.out.print(".");
                        bufferedImage = graphicsConfiguration.createCompatibleImage(n9 / 2, n10 / 2, 3);
                        Graphics2D graphics2D2 = bufferedImage.createGraphics();
                        graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2D2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D2.drawImage(bufferedImage2, 0, 0, n9 / 2, n10 / 2, null);
                        n9 /= 2;
                        n10 /= 2;
                        BufferedImage bufferedImage3 = bufferedImage;
                        bufferedImage = bufferedImage2;
                        bufferedImage2 = bufferedImage3;
                    }
                    System.out.print("\n");
                    this.resizedImg.getGraphics().drawImage(bufferedImage, 0, 0, n5, n6, null);
                } else {
                    this.resizedImg.getGraphics().drawImage(this.img, 0, 0, n5, n6, null);
                }
            } else {
                this.resizedImg = graphicsConfiguration.createCompatibleImage(this.maxResizedWidth, this.maxResizedHeight, 3);
                this.shiftx = Math.max(n - this.maxResizedWidth / 3, 0) + n7;
                this.shifty = Math.max(n2 - this.maxResizedHeight / 3, 0) + n8;
                this.resizedImg.getGraphics().drawImage(this.img, 0, 0, this.maxResizedWidth, this.maxResizedHeight, (int)((double)this.shiftx / mapCoordinates.getXMagnitude() * this.resolution / 200.0 + 0.5), (int)((double)this.shifty / mapCoordinates.getXMagnitude() * this.resolution / 200.0 + 0.5), (int)((double)(this.shiftx + this.maxResizedWidth) / mapCoordinates.getXMagnitude() * this.resolution / 200.0 + 0.5), (int)((double)(this.shifty + this.maxResizedHeight) / mapCoordinates.getYMagnitude() * this.resolution / 200.0 + 0.5), null);
            }
        }
        graphics2D.drawImage(this.resizedImg, n, n2, n + n3, n2 + n4, n - this.shiftx, n2 - this.shifty, n + n3 - this.shiftx, n2 + n4 - this.shifty, null);
    }
}

