/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.circuit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.fidocadj.circuit.ImageAsCanvas;
import net.sourceforge.fidocadj.circuit.MouseMoveClickHandler;
import net.sourceforge.fidocadj.circuit.MouseWheelHandler;
import net.sourceforge.fidocadj.circuit.PopUpMenu;
import net.sourceforge.fidocadj.circuit.Ruler;
import net.sourceforge.fidocadj.circuit.controllers.ContinuosMoveActions;
import net.sourceforge.fidocadj.circuit.controllers.CopyPasteActions;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.controllers.PrimitivesParInterface;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.circuit.controllers.UndoActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.circuit.views.Drawing;
import net.sourceforge.fidocadj.clipboard.TextTransfer;
import net.sourceforge.fidocadj.dialogs.DialogParameters;
import net.sourceforge.fidocadj.dialogs.LayerInfo;
import net.sourceforge.fidocadj.dialogs.ParameterDescription;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.swing.ColorSwing;
import net.sourceforge.fidocadj.graphic.swing.Graphics2DSwing;
import net.sourceforge.fidocadj.primitives.GraphicPrimitive;
import net.sourceforge.fidocadj.timer.MyTimer;
import net.sourceforge.fidocadj.toolbars.ChangeGridState;
import net.sourceforge.fidocadj.toolbars.ChangeSelectedLayer;
import net.sourceforge.fidocadj.toolbars.ChangeSelectionListener;
import net.sourceforge.fidocadj.toolbars.ChangeZoomListener;

public class CircuitPanel
extends JPanel
implements ChangeSelectedLayer,
ChangeGridState,
ChangeZoomListener,
ChangeSelectionListener,
PrimitivesParInterface {
    Graphics2DSwing graphicSwing;
    private transient MapCoordinates cs;
    public boolean antiAlias;
    private boolean isGridVisible;
    private Color backgroundColor = Color.white;
    private Rectangle evidenceRect;
    public static final int MARGIN = 20;
    static final ColorSwing editingColor = new ColorSwing(Color.green);
    public transient DrawingModel dmp;
    public JScrollPane father;
    private static final int MINSIZEX = 1000;
    private static final int MINSIZEY = 1000;
    public Drawing drawingAgent;
    private EditorActions edt;
    private CopyPasteActions cpa;
    private ParserActions pa;
    private UndoActions ua;
    private ContinuosMoveActions eea;
    private SelectionActions sa;
    public boolean profileTime;
    private double average;
    private double record;
    private double runs;
    private Rectangle scrollRectangle;
    public boolean extStrict;
    private final Ruler ruler;
    PopUpMenu popup;
    MouseWheelHandler mwHandler;
    MouseMoveClickHandler mmcHandler;
    private ChangeZoomListener zoomListener;
    private ChangeSelectionListener selectionListener;
    private ChangeSelectionListener scrollGestureSelectionListener;

    public CircuitPanel(boolean bl) {
        this.setDrawingModel(new DrawingModel());
        this.mwHandler = new MouseWheelHandler(this);
        this.mmcHandler = new MouseMoveClickHandler(this);
        this.graphicSwing = new Graphics2DSwing();
        this.ruler = new Ruler(editingColor.getColorSwing(), editingColor.getColorSwing().darker().darker());
        this.isGridVisible = true;
        this.zoomListener = null;
        this.antiAlias = true;
        this.record = 1.0E100;
        this.evidenceRect = new Rectangle(0, 0, -1, -1);
        this.cs = new MapCoordinates();
        this.cs.setXCenter(0.0);
        this.cs.setYCenter(0.0);
        this.cs.setXMagnitude(4.0);
        this.cs.setYMagnitude(4.0);
        this.cs.setOrientation(0);
        this.setOpaque(true);
        this.runs = 0.0;
        this.average = 0.0;
        if (bl) {
            this.addMouseListener(this.mmcHandler);
            this.addMouseMotionListener(this.mmcHandler);
            this.addKeyListener(this.mwHandler);
            this.setFocusable(true);
            this.popup = new PopUpMenu(this);
            this.popup.registerActiveKeys();
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (CircuitPanel.this.eea.isEnteringMacro() && !CircuitPanel.this.isFocusOwner()) {
                        CircuitPanel.this.requestFocus();
                    }
                }
            });
        }
    }

    @Override
    public void showPopUpMenu(int n, int n2) {
        this.popup.showPopUpMenu(this, n, n2);
    }

    @Override
    public void getFocus() {
        this.requestFocusInWindow();
    }

    @Override
    public void setSelectionState(int n, String string) {
        if (this.selectionListener != null && n != this.eea.actionSelected) {
            this.selectionListener.setSelectionState(n, string);
            this.selectionListener.setStrictCompatibility(this.extStrict);
        }
        if (this.scrollGestureSelectionListener != null) {
            this.scrollGestureSelectionListener.setSelectionState(n, string);
        }
        this.eea.setState(n, string);
        this.mmcHandler.selectCursor();
    }

    public void setScrollRectangle(Rectangle rectangle) {
        this.scrollRectangle = rectangle;
        this.repaint();
    }

    public void addChangeZoomListener(ChangeZoomListener changeZoomListener) {
        this.zoomListener = changeZoomListener;
    }

    public void addChangeSelectionListener(ChangeSelectionListener changeSelectionListener) {
        this.selectionListener = changeSelectionListener;
        this.eea.setChangeSelectionListener(changeSelectionListener);
    }

    public void addScrollGestureSelectionListener(ChangeSelectionListener changeSelectionListener) {
        this.scrollGestureSelectionListener = changeSelectionListener;
    }

    public int getCurrentLayer() {
        return this.eea.currentLayer;
    }

    public void setCurrentLayer(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.dmp.getLayers().size()) {
            n2 = this.dmp.getLayers().size() - 1;
        }
        this.eea.currentLayer = n2;
    }

    @Override
    public void changeSelectedLayer(int n) {
        this.eea.currentLayer = n;
        if (this.edt.setLayerForSelectedPrimitives(n)) {
            this.repaint();
        }
    }

    @Override
    public void setGridVisibility(boolean bl) {
        this.isGridVisible = bl;
        this.repaint();
    }

    public boolean getGridVisibility() {
        return this.isGridVisible;
    }

    @Override
    public void setSnapState(boolean bl) {
        this.cs.setSnap(bl);
    }

    public boolean getSnapState() {
        return this.cs.getSnap();
    }

    @Override
    public void changeZoomByStep(boolean bl, int n, int n2, double d) {
        double d2;
        int n3 = this.cs.unmapXnosnap(n);
        int n4 = this.cs.unmapYnosnap(n2);
        double d3 = d2 = this.cs.getXMagnitude();
        d2 = bl ? (d2 *= d) : (d2 /= d);
        if (d2 > 40.0) {
            d2 = 40.0;
        }
        if (d2 < 0.1) {
            d2 = 0.1;
        }
        if (Math.abs(d3 - (d2 = (double)Math.round(d2 * 100.0) / 100.0)) < 1.0E-5) {
            return;
        }
        this.cs.setMagnitudes(d2, d2);
        int n5 = this.father.getViewport().getExtentSize().width;
        int n6 = this.father.getViewport().getExtentSize().height;
        Point point = this.father.getViewport().getViewPosition();
        int n7 = n - point.x;
        int n8 = n2 - point.y;
        Rectangle rectangle = new Rectangle(this.cs.mapXi(n3, n4, false) - n7, this.cs.mapYi(n3, n4, false) - n8, n5, n6);
        this.updateSizeOfScrollBars(rectangle);
    }

    public void updateSizeOfScrollBars(Rectangle rectangle) {
        PointG pointG = new PointG();
        DimensionG dimensionG = DrawingSize.getImageSize(this.dmp, this.cs.getXMagnitude(), false, pointG);
        int n = this.cs.mapXi(1000.0, 1000.0, false);
        int n2 = this.cs.mapYi(1000.0, 1000.0, false);
        Dimension dimension = new Dimension(Math.max(dimensionG.width + 20, n), Math.max(dimensionG.height + 20, n2));
        this.setPreferredSize(dimension);
        if (rectangle != null) {
            this.scrollRectangle = rectangle;
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getSelectionState() {
        return this.eea.getSelectionState();
    }

    @Override
    public void changeZoom(double d) {
        double d2 = (double)Math.round(d * 100.0) / 100.0;
        this.cs.setMagnitudes(d2, d2);
        this.eea.successiveMove = false;
        this.requestFocusInWindow();
        this.repaint();
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    @Override
    public void setEvidenceRect(int n, int n2, int n3, int n4) {
        this.evidenceRect = new Rectangle();
        this.evidenceRect.x = n;
        this.evidenceRect.y = n2;
        this.evidenceRect.height = n4;
        this.evidenceRect.width = n3;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        MyTimer myTimer = new MyTimer();
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.graphicSwing.setGraphicContext(graphics2D);
        this.activateDrawingSettings(graphics2D);
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.dmp.imgCanvas.drawCanvasImage(graphics2D, this.cs);
        if (this.isGridVisible) {
            this.graphicSwing.drawGrid(this.cs, 0, 0, this.getWidth(), this.getHeight());
        }
        graphics.setColor(Color.black);
        this.graphicSwing.setZoom(this.cs.getXMagnitude());
        this.drawingAgent.draw(this.graphicSwing, this.cs);
        this.dmp.imgCanvas.trackExtremePoints(this.cs);
        if (this.zoomListener != null) {
            this.zoomListener.changeZoom(this.cs.getXMagnitude());
        }
        this.drawingAgent.drawSelectedHandles(this.graphicSwing, this.cs);
        graphics.setColor(editingColor.getColorSwing());
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.evidenceRect != null && this.eea.actionSelected == 1) {
            graphics.drawRect(this.evidenceRect.x, this.evidenceRect.y, this.evidenceRect.width, this.evidenceRect.height);
        } else {
            this.evidenceRect = null;
        }
        this.eea.drawPrimEdit(this.graphicSwing, this.cs);
        this.ruler.drawRuler(graphics, this.cs);
        this.setSizeIfNeeded();
        if (this.scrollRectangle != null) {
            Rectangle rectangle = this.scrollRectangle;
            this.scrollRectangle = null;
            this.scrollRectToVisible(rectangle);
        }
        if (this.profileTime) {
            double d = myTimer.getElapsed();
            graphics2D.drawString("Version: 0.24.8", 0, 100);
            graphics.drawString("Time elapsed: " + d + " ms", 0, 50);
            this.runs += 1.0;
            this.average += d;
            if (d < this.record) {
                this.record = d;
            }
            System.out.println("R: Time elapsed: " + d + " averaging " + this.average / this.runs + "ms in " + this.runs + " redraws; record: " + this.record + " ms");
        }
    }

    private void activateDrawingSettings(Graphics2D graphics2D) {
        if (this.antiAlias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        }
    }

    private void setSizeIfNeeded() {
        Dimension dimension = new Dimension(this.cs.getXMax(), this.cs.getYMax());
        if (dimension.width > 0 && dimension.height > 0) {
            int n = this.cs.mapXi(1000.0, 1000.0, false);
            int n2 = this.cs.mapYi(1000.0, 1000.0, false);
            Dimension dimension2 = new Dimension(Math.max(dimension.width + 20, n), Math.max(dimension.height + 20, n2));
            Dimension dimension3 = this.getPreferredSize();
            if (dimension2.width != dimension3.width || dimension2.height != dimension3.height) {
                this.setPreferredSize(dimension2);
                this.revalidate();
            }
        }
    }

    @Override
    public void validate() {
        int n = this.cs.mapXi(1000.0, 1000.0, false);
        int n2 = this.cs.mapYi(1000.0, 1000.0, false);
        Dimension dimension = new Dimension(Math.max(this.cs.getXMax() + 20, n), Math.max(this.cs.getYMax() + 20, n2));
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width != dimension2.width || dimension.height != dimension2.height) {
            this.setPreferredSize(dimension);
        }
        super.validate();
    }

    public DrawingModel getDrawingModel() {
        return this.dmp;
    }

    public void setDrawingModel(DrawingModel drawingModel) {
        this.dmp = drawingModel;
        this.sa = new SelectionActions(this.dmp);
        this.pa = new ParserActions(this.dmp);
        this.ua = new UndoActions(this.pa);
        this.edt = new EditorActions(this.dmp, this.sa, this.ua);
        this.eea = new ContinuosMoveActions(this.dmp, this.sa, this.ua, this.edt);
        this.drawingAgent = new Drawing(this.dmp);
        this.eea.setPrimitivesParListener(this);
        this.cpa = new CopyPasteActions(this.dmp, this.edt, this.sa, this.pa, this.ua, new TextTransfer());
    }

    public SelectionActions getSelectionActions() {
        return this.sa;
    }

    public EditorActions getEditorActions() {
        return this.edt;
    }

    public CopyPasteActions getCopyPasteActions() {
        return this.cpa;
    }

    public ParserActions getParserActions() {
        return this.pa;
    }

    public UndoActions getUndoActions() {
        return this.ua;
    }

    public ContinuosMoveActions getContinuosMoveActions() {
        return this.eea;
    }

    @Override
    public void setPropertiesForPrimitive() {
        Object object;
        Vector<ParameterDescription> vector;
        GraphicPrimitive graphicPrimitive = this.sa.getFirstSelectedPrimitive();
        if (graphicPrimitive == null) {
            return;
        }
        if (this.sa.isUniquePrimitiveSelected()) {
            vector = graphicPrimitive.getControls();
        } else {
            vector = new Vector(1);
            object = new ParameterDescription();
            ((ParameterDescription)object).parameter = new LayerInfo(graphicPrimitive.getLayer());
            ((ParameterDescription)object).description = Globals.messages.getString("ctrl_layer");
            vector.add((ParameterDescription)object);
        }
        object = new DialogParameters((JFrame)Globals.activeWindow, vector, this.extStrict, this.dmp.getLayers());
        ((Dialog)object).setVisible(true);
        if (((DialogParameters)object).active) {
            if (this.sa.isUniquePrimitiveSelected()) {
                graphicPrimitive.setControls(((DialogParameters)object).getCharacteristics());
            } else {
                ParameterDescription parameterDescription = vector.get(0);
                ((DialogParameters)object).getCharacteristics();
                if (parameterDescription.parameter instanceof LayerInfo) {
                    int n = ((LayerInfo)parameterDescription.parameter).getLayer();
                    this.edt.setLayerForSelectedPrimitives(n);
                } else {
                    System.out.println("Warning: unexpected parameter! (layer)");
                }
            }
            this.dmp.setChanged(true);
            this.dmp.sortPrimitiveLayers();
            this.ua.saveUndoState();
            this.repaint();
        }
    }

    @Override
    public void selectAndSetProperties(int n, int n2) {
        this.sa.setSelectionAll(false);
        this.edt.handleSelection(this.cs, n, n2, false);
        this.repaint();
        this.setPropertiesForPrimitive();
    }

    public boolean getStrictCompatibility() {
        return this.extStrict;
    }

    @Override
    public void setStrictCompatibility(boolean bl) {
        this.extStrict = bl;
    }

    public void setMapCoordinates(MapCoordinates mapCoordinates) {
        this.cs = mapCoordinates;
        this.dmp.setChanged(true);
    }

    public MapCoordinates getMapCoordinates() {
        return this.cs;
    }

    @Override
    public void forcesRepaint() {
        this.repaint();
    }

    @Override
    public void forcesRepaint(int n, int n2, int n3, int n4) {
        this.repaint(n, n2, n3, n4);
    }

    public Ruler getRuler() {
        return this.ruler;
    }

    public boolean isProfiling() {
        return this.profileTime;
    }

    public ImageAsCanvas getAttachedImage() {
        return this.dmp.imgCanvas;
    }
}

