/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.toolbars.ChangeSelectionListener;

public final class ScrollGestureRecognizer
implements AWTEventListener,
ChangeSelectionListener {
    private int actionSelected;
    private boolean oldGesture = false;
    private static ScrollGestureRecognizer instance = new ScrollGestureRecognizer();
    Point location = new Point();

    public ScrollGestureRecognizer() {
        this.start();
    }

    public static ScrollGestureRecognizer getInstance() {
        return instance;
    }

    void start() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
    }

    void stop() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        boolean bl = (SwingUtilities.isMiddleMouseButton(mouseEvent) || this.actionSelected == 3) && mouseEvent.getID() == 506;
        Component component = mouseEvent.getComponent();
        if (!(component instanceof CircuitPanel)) {
            return;
        }
        JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, mouseEvent.getComponent());
        if (jViewport == null) {
            return;
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(jViewport);
        if (jRootPane == null) {
            return;
        }
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jRootPane.getGlassPane());
        if (!this.oldGesture && !bl) {
            this.location = point;
        }
        this.oldGesture = bl;
        if (!bl) {
            return;
        }
        int n = -(point.x - this.location.x);
        int n2 = -(point.y - this.location.y);
        this.location.x = point.x;
        this.location.y = point.y;
        Point point2 = jViewport.getViewPosition();
        point2.translate(n, n2);
        if (point2.x < 0) {
            point2.x = 0;
        } else if (point2.x >= jViewport.getView().getWidth() - jViewport.getWidth()) {
            point2.x = jViewport.getView().getWidth() - jViewport.getWidth();
        }
        if (point2.y < 0) {
            point2.y = 0;
        } else if (point2.y >= jViewport.getView().getHeight() - jViewport.getHeight()) {
            point2.y = jViewport.getView().getHeight() - jViewport.getHeight();
        }
        jViewport.setViewPosition(point2);
    }

    @Override
    public void setSelectionState(int n, String string) {
        this.actionSelected = n;
    }

    @Override
    public void setStrictCompatibility(boolean bl) {
    }

    @Override
    public int getSelectionState() {
        return this.actionSelected;
    }
}

