/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.export.ExportGraphic;
import net.sourceforge.fidocadj.geom.ChangeCoordinatesListener;
import net.sourceforge.fidocadj.globals.Globals;

class RunExport
implements Runnable {
    private File file;
    private DrawingModel dmp;
    private String format;
    private double unitPerPixel;
    private boolean antiAlias;
    private boolean blackWhite;
    private boolean ext;
    private boolean resBased;
    private boolean splitLayers;
    private int xsize;
    private int ysize;
    private JFrame parent;
    private ChangeCoordinatesListener coordL;

    RunExport() {
    }

    public void setParam(File file, DrawingModel drawingModel, String string, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, boolean bl5, JFrame jFrame) {
        this.file = file;
        this.dmp = drawingModel;
        this.format = string;
        this.unitPerPixel = d;
        this.antiAlias = bl;
        this.blackWhite = bl2;
        this.ext = bl3;
        this.xsize = n;
        this.ysize = n2;
        this.resBased = bl4;
        this.parent = jFrame;
        this.splitLayers = bl5;
    }

    public void setCoordinateListener(ChangeCoordinatesListener changeCoordinatesListener) {
        this.coordL = changeCoordinatesListener;
    }

    @Override
    public void run() {
        try {
            if (this.resBased) {
                ExportGraphic.export(this.file, this.dmp, this.format, this.unitPerPixel, this.antiAlias, this.blackWhite, this.ext, true, this.splitLayers);
            } else {
                ExportGraphic.exportSize(this.file, this.dmp, this.format, this.xsize, this.ysize, this.antiAlias, this.blackWhite, this.ext, true, this.splitLayers);
            }
            if (this.coordL == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(RunExport.this.parent, Globals.messages.getString("Export_completed"));
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RunExport.this.coordL.changeInfos(Globals.messages.getString("Export_completed"));
                    }
                });
            }
        }
        catch (IOException iOException) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(RunExport.this.parent, Globals.messages.getString("Export_error") + iOException);
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(RunExport.this.parent, Globals.messages.getString("Illegal_filename"));
                }
            });
        }
        catch (NegativeArraySizeException | OutOfMemoryError throwable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(RunExport.this.parent, Globals.messages.getString("Eport_Memory_Error"));
                }
            });
        }
    }
}

