/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.dialogs.print.DialogPrint;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.GraphicsInterface;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.graphic.swing.ColorSwing;
import net.sourceforge.fidocadj.graphic.swing.Graphics2DSwing;
import net.sourceforge.fidocadj.layers.LayerDesc;

public class PrintTools
implements Printable {
    private boolean printMirror = false;
    private boolean printFitToPage = false;
    private boolean printLandscape = false;
    private boolean printBlackWhite;
    private int currentLayerSelected;
    private double topMargin = -1.0;
    private double bottomMargin = -1.0;
    private double leftMargin = -1.0;
    private double rightMargin = -1.0;
    private CircuitPanel cc;
    private boolean showMargins;
    private static final double LIMIT = 1.0E-5;
    private static final double MULT = 16.0;
    private static final double INCH = 2.54;
    private static final double NATIVERES = 72.0;

    public PrintTools() {
        this.adjustMargins(PrinterJob.getPrinterJob().defaultPage());
        this.showMargins = false;
        this.currentLayerSelected = -1;
    }

    private void adjustMargins(PageFormat pageFormat) {
        if (this.leftMargin < 0.0) {
            this.leftMargin = pageFormat.getImageableX() / 72.0 * 2.54 + 0.01;
        }
        if (this.topMargin < 0.0) {
            this.topMargin = pageFormat.getImageableY() / 72.0 * 2.54 + 0.01;
        }
        if (this.rightMargin < 0.0) {
            this.rightMargin = (pageFormat.getWidth() - pageFormat.getImageableX() - pageFormat.getImageableWidth()) / 72.0 * 2.54 + 0.01;
        }
        if (this.bottomMargin < 0.0) {
            this.bottomMargin = (pageFormat.getHeight() - pageFormat.getImageableY() - pageFormat.getImageableHeight()) / 72.0 * 2.54 + 0.01;
        }
    }

    public void setShowMargins(boolean bl) {
        this.showMargins = bl;
    }

    public void setMargins(double d, double d2, double d3, double d4) {
        if (d > 0.0) {
            this.topMargin = d;
        }
        if (d2 > 0.0) {
            this.bottomMargin = d2;
        }
        if (d3 > 0.0) {
            this.leftMargin = d3;
        }
        if (d4 > 0.0) {
            this.rightMargin = d4;
        }
    }

    public void associateToCircuitPanel(CircuitPanel circuitPanel) {
        this.cc = circuitPanel;
    }

    public void printDrawing(JFrame jFrame) {
        boolean bl;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        DialogPrint dialogPrint = new DialogPrint(jFrame, this.cc.getDrawingModel(), pageFormat);
        dialogPrint.setMirror(this.printMirror);
        dialogPrint.setFit(this.printFitToPage);
        dialogPrint.setBW(this.printBlackWhite);
        dialogPrint.setLandscape(this.printLandscape);
        dialogPrint.setMaxMargins(pageFormat.getWidth() / 72.0 * 2.54, pageFormat.getHeight() / 72.0 * 2.54);
        dialogPrint.setMargins(this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin);
        do {
            dialogPrint.setVisible(true);
            bl = this.configurePrinting(dialogPrint, pageFormat, true);
            if (dialogPrint.shouldPrint()) continue;
            return;
        } while (bl);
        try {
            this.executePrinting(printerJob);
        }
        catch (PrinterException printerException) {
            JOptionPane.showMessageDialog(jFrame, Globals.messages.getString("Print_uncomplete"));
        }
    }

    public boolean configurePrinting(DialogPrint dialogPrint, PageFormat pageFormat, boolean bl) {
        int n;
        boolean bl2 = false;
        if (!dialogPrint.shouldPrint() && bl) {
            return true;
        }
        this.printMirror = dialogPrint.getMirror();
        this.printFitToPage = dialogPrint.getFit();
        this.printLandscape = dialogPrint.getLandscape();
        this.printBlackWhite = dialogPrint.getBW();
        try {
            this.topMargin = dialogPrint.getTMargin();
            this.bottomMargin = dialogPrint.getBMargin();
            this.leftMargin = dialogPrint.getLMargin();
            this.rightMargin = dialogPrint.getRMargin();
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(Globals.messages.getString("Format_invalid"));
        }
        if (bl && (this.topMargin / 2.54 * 72.0 < pageFormat.getImageableY() || this.bottomMargin / 2.54 * 72.0 < pageFormat.getHeight() - pageFormat.getImageableHeight() - pageFormat.getImageableY() || this.leftMargin / 2.54 * 72.0 < pageFormat.getImageableX() || this.rightMargin / 2.54 * 72.0 < pageFormat.getWidth() - pageFormat.getImageableWidth() - pageFormat.getImageableX()) && (n = JOptionPane.showConfirmDialog(dialogPrint, Globals.messages.getString("Print_outside_regions"), "", 0)) != 0) {
            bl2 = true;
        }
        this.currentLayerSelected = dialogPrint.getSingleLayerToPrint();
        this.cc.getSelectionActions().setSelectionAll(false);
        return bl2;
    }

    private void executePrinting(PrinterJob printerJob) throws PrinterException {
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            if (this.printLandscape) {
                hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
            } else {
                hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
            }
            printerJob.print(hashPrintRequestAttributeSet);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Object object;
        Object object2;
        Object object3;
        int n2 = 5;
        double d = 0.0625;
        double d2 = 0.0625;
        double d3 = 5.76;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.showMargins) {
            graphics2D.setColor(new Color(255, 200, 200));
            graphics2D.fillRect(0, 0, (int)pageFormat.getImageableX(), (int)pageFormat.getHeight());
            graphics2D.fillRect(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getImageableY());
            graphics2D.fillRect((int)(pageFormat.getImageableX() + pageFormat.getImageableWidth()), 0, (int)pageFormat.getImageableX(), (int)pageFormat.getHeight());
            graphics2D.fillRect(0, (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight()), (int)pageFormat.getWidth(), (int)(pageFormat.getHeight() - pageFormat.getImageableHeight() - pageFormat.getImageableY()));
        }
        if (this.printMirror) {
            graphics2D.translate(pageFormat.getWidth() - this.rightMargin / 2.54 * 72.0, this.topMargin / 2.54 * 72.0);
            graphics2D.scale(-d, d2);
        } else {
            graphics2D.translate(this.leftMargin / 2.54 * 72.0, this.topMargin / 2.54 * 72.0);
            graphics2D.scale(d, d2);
        }
        double d4 = (pageFormat.getWidth() - (this.leftMargin + this.rightMargin) / 2.54 * 72.0) * 16.0;
        double d5 = (pageFormat.getHeight() - (this.topMargin + this.bottomMargin) / 2.54 * 72.0) * 16.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d4 - (double)(2 * n2), d5 - (double)(2 * n2));
        if (this.showMargins) {
            object3 = new float[]{150.0f};
            object2 = new BasicStroke(50.0f, 0, 0, 10.0f, (float[])object3, 0.0f);
            graphics2D.setStroke((Stroke)object2);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
        }
        graphics2D.clip(double_);
        if (this.printFitToPage) {
            object2 = DrawingSize.calculateZoomToFit(this.cc.getDrawingModel(), (int)((pageFormat.getWidth() - (this.leftMargin + this.rightMargin) / 2.54 * 72.0) * 16.0) - 2 * n2, (int)((pageFormat.getHeight() - (this.topMargin + this.bottomMargin) / 2.54 * 72.0) * 16.0) - 2 * n2, true);
            d3 = ((MapCoordinates)object2).getXMagnitude();
        }
        object3 = new MapCoordinates();
        ((MapCoordinates)object3).setMagnitudes(d3, d3);
        object2 = new PointG(0, 0);
        DimensionG dimensionG = DrawingSize.getImageSize(this.cc.getDrawingModel(), d3, true, (PointG)object2);
        int n3 = dimensionG.width;
        int n4 = dimensionG.height;
        int n5 = (int)Math.ceil((double)n3 / d4);
        int n6 = (int)Math.ceil((double)n4 / d5);
        int n7 = n5 * n6;
        int n8 = n % n5;
        int n9 = n / n5;
        if (this.printFitToPage) {
            graphics2D.translate(-((PointG)object2).x, -((PointG)object2).y);
        }
        if (n >= n7) {
            graphics2D.setTransform(affineTransform);
            return 1;
        }
        if (n > 0) {
            graphics2D.translate(-(d4 * (double)n8), 0.0);
            graphics2D.translate(0.0, -(d5 * (double)n9));
        }
        Vector<LayerDesc> vector = this.cc.dmp.getLayers();
        if (this.currentLayerSelected >= 0) {
            this.cc.dmp.drawOnlyLayer = this.currentLayerSelected;
        }
        if (this.printBlackWhite) {
            object = new Vector();
            for (int i = 0; i < 16; ++i) {
                ((Vector)object).add(new LayerDesc(new ColorSwing(Color.black), vector.get(i).getVisible(), "B/W", vector.get(i).getAlpha()));
            }
            this.cc.dmp.setLayers((Vector<LayerDesc>)object);
        }
        object = new Graphics2DSwing(graphics2D);
        ((Graphics2DSwing)object).setZoom(((MapCoordinates)object3).getXMagnitude());
        this.cc.drawingAgent.draw((GraphicsInterface)object, (MapCoordinates)object3);
        if (this.currentLayerSelected >= 0) {
            this.cc.dmp.setDrawOnlyPads(true);
            this.cc.drawingAgent.draw(new Graphics2DSwing(graphics2D), (MapCoordinates)object3);
            this.cc.dmp.setDrawOnlyPads(false);
            this.cc.dmp.drawOnlyLayer = -1;
        }
        this.cc.dmp.setLayers(vector);
        graphics2D.setTransform(affineTransform);
        return 0;
    }
}

