/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.fidocadj.FidoFrame;
import net.sourceforge.fidocadj.globals.Globals;

class OpenFile
implements Runnable {
    private FidoFrame parent;

    OpenFile() {
    }

    public void setParam(FidoFrame fidoFrame) {
        this.parent = fidoFrame;
    }

    @Override
    public void run() {
        String string;
        String string2;
        Serializable serializable;
        if (Globals.useNativeFileDialogs) {
            serializable = new FileDialog((Frame)this.parent, Globals.messages.getString("Open"));
            ((FileDialog)serializable).setDirectory(this.parent.getFileTools().openFileDirectory);
            ((FileDialog)serializable).setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase(OpenFile.this.parent.getLocale()).endsWith(".fcd");
                }
            });
            ((Dialog)serializable).setVisible(true);
            string2 = ((FileDialog)serializable).getFile();
            string = ((FileDialog)serializable).getDirectory();
        } else {
            serializable = new JFileChooser();
            ((JFileChooser)serializable).setCurrentDirectory(new File(this.parent.getFileTools().openFileDirectory));
            ((JFileChooser)serializable).setDialogTitle(Globals.messages.getString("Open"));
            ((JFileChooser)serializable).setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".fcd") || file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "FidoCadJ (.fcd)";
                }
            });
            if (((JFileChooser)serializable).showOpenDialog(this.parent) != 0) {
                return;
            }
            string2 = ((JFileChooser)serializable).getSelectedFile().getName();
            string = ((JFileChooser)serializable).getSelectedFile().getParentFile().getPath();
        }
        if (string2 != null) {
            int n;
            serializable = new File(Globals.createCompleteFileName(string, string2));
            if (!Globals.checkExtension(string2, "fcd") && (n = ((File)serializable).exists() ? JOptionPane.showConfirmDialog(null, Globals.messages.getString("Warning_extension"), Globals.messages.getString("Warning"), 0, 2) : 0) == 0) {
                string2 = Globals.adjustExtension(string2, "fcd");
            }
            try {
                FidoFrame fidoFrame;
                if (this.parent.cc.getUndoActions().getModified() || !this.parent.cc.dmp.isEmpty()) {
                    fidoFrame = new FidoFrame(this.parent.runsAsApplication, this.parent.getLocale());
                    fidoFrame.init();
                    fidoFrame.setBounds(this.parent.getX() + 20, this.parent.getY() + 20, fidoFrame.getWidth(), fidoFrame.getHeight());
                    fidoFrame.loadLibraries();
                    fidoFrame.setVisible(true);
                } else {
                    fidoFrame = this.parent;
                }
                fidoFrame.cc.getParserActions().openFileName = Globals.createCompleteFileName(string, string2);
                if (this.parent.runsAsApplication) {
                    this.parent.prefs.put("OPEN_DIR", string);
                }
                fidoFrame.getFileTools().openFileDirectory = string;
                fidoFrame.getFileTools().openFile();
                fidoFrame.cc.getUndoActions().saveUndoState();
                fidoFrame.cc.getUndoActions().setModified(false);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.parent, Globals.messages.getString("Open_error") + iOException);
            }
        }
    }
}

