/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sourceforge.fidocadj.ExportTools;
import net.sourceforge.fidocadj.FidoFrame;
import net.sourceforge.fidocadj.OpenFile;
import net.sourceforge.fidocadj.PrintTools;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.circuit.ImageAsCanvas;
import net.sourceforge.fidocadj.circuit.controllers.ContinuosMoveActions;
import net.sourceforge.fidocadj.circuit.controllers.CopyPasteActions;
import net.sourceforge.fidocadj.circuit.controllers.EditorActions;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.controllers.SelectionActions;
import net.sourceforge.fidocadj.clipboard.TextTransfer;
import net.sourceforge.fidocadj.dialogs.DialogAbout;
import net.sourceforge.fidocadj.dialogs.DialogAttachImage;
import net.sourceforge.fidocadj.dialogs.DialogLayer;
import net.sourceforge.fidocadj.dialogs.EnterCircuitFrame;
import net.sourceforge.fidocadj.geom.ChangeCoordinatesListener;
import net.sourceforge.fidocadj.globals.Globals;

public class MenuTools
implements MenuListener {
    JCheckBoxMenuItem libs;

    public JMenuBar defineMenuBar(ActionListener actionListener) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.defineFileMenu(actionListener));
        jMenuBar.add(this.defineEditMenu(actionListener));
        jMenuBar.add(this.defineViewMenu(actionListener));
        jMenuBar.add(this.defineCircuitMenu(actionListener));
        JMenu jMenu = this.defineAboutMenu(actionListener);
        if (!Globals.desktopInt.handleAbout) {
            jMenuBar.add(jMenu);
        }
        return jMenuBar;
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    public JMenu defineFileMenu(ActionListener actionListener) {
        JMenu jMenu = new JMenu(Globals.messages.getString("File"));
        JMenuItem jMenuItem = new JMenuItem(Globals.messages.getString("New"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Globals.shortcutKey));
        JMenuItem jMenuItem2 = new JMenuItem(Globals.messages.getString("Open"));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, Globals.shortcutKey));
        JMenuItem jMenuItem3 = new JMenuItem(Globals.messages.getString("Save"));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, Globals.shortcutKey));
        JMenuItem jMenuItem4 = new JMenuItem(Globals.messages.getString("SaveName"));
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(83, Globals.shortcutKey | 1));
        JMenuItem jMenuItem5 = new JMenuItem(Globals.messages.getString("Save_split"));
        JMenuItem jMenuItem6 = new JMenuItem(Globals.messages.getString("Export"));
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(69, Globals.shortcutKey));
        JMenuItem jMenuItem7 = new JMenuItem(Globals.messages.getString("Print"));
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(80, Globals.shortcutKey));
        JMenuItem jMenuItem8 = new JMenuItem(Globals.messages.getString("Close"));
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(87, Globals.shortcutKey));
        JMenuItem jMenuItem9 = new JMenuItem(Globals.messages.getString("Circ_opt"));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        jMenu.add(jMenuItem6);
        jMenu.add(jMenuItem7);
        jMenu.addSeparator();
        if (!Globals.desktopInt.handlePreferences) {
            jMenu.add(jMenuItem9);
            jMenu.addSeparator();
        }
        jMenu.add(jMenuItem8);
        jMenuItem.addActionListener(actionListener);
        jMenuItem2.addActionListener(actionListener);
        jMenuItem6.addActionListener(actionListener);
        jMenuItem7.addActionListener(actionListener);
        jMenuItem8.addActionListener(actionListener);
        jMenuItem3.addActionListener(actionListener);
        jMenuItem4.addActionListener(actionListener);
        jMenuItem5.addActionListener(actionListener);
        jMenuItem9.addActionListener(actionListener);
        return jMenu;
    }

    public JMenu defineEditMenu(ActionListener actionListener) {
        JMenu jMenu = new JMenu(Globals.messages.getString("Edit_menu"));
        JMenuItem jMenuItem = new JMenuItem(Globals.messages.getString("Undo"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, Globals.shortcutKey));
        JMenuItem jMenuItem2 = new JMenuItem(Globals.messages.getString("Redo"));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(90, Globals.shortcutKey | 1));
        JMenuItem jMenuItem3 = new JMenuItem(Globals.messages.getString("Cut"));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(88, Globals.shortcutKey));
        JMenuItem jMenuItem4 = new JMenuItem(Globals.messages.getString("Copy"));
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(67, Globals.shortcutKey));
        JMenuItem jMenuItem5 = new JMenuItem(Globals.messages.getString("Copy_split"));
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(77, Globals.shortcutKey));
        JMenuItem jMenuItem6 = new JMenuItem(Globals.messages.getString("Copy_as_image"));
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(73, Globals.shortcutKey));
        JMenuItem jMenuItem7 = new JMenuItem(Globals.messages.getString("Paste"));
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(86, Globals.shortcutKey));
        JMenuItem jMenuItem8 = new JMenuItem(Globals.messages.getString("DefineClipboard"));
        JMenuItem jMenuItem9 = new JMenuItem(Globals.messages.getString("SelectAll"));
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(65, Globals.shortcutKey));
        JMenuItem jMenuItem10 = new JMenuItem(Globals.messages.getString("Duplicate"));
        jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(68, Globals.shortcutKey));
        JMenuItem jMenuItem11 = new JMenuItem(Globals.messages.getString("Rotate"));
        jMenuItem11.setAccelerator(KeyStroke.getKeyStroke("R"));
        JMenuItem jMenuItem12 = new JMenuItem(Globals.messages.getString("Mirror_E"));
        jMenuItem12.setAccelerator(KeyStroke.getKeyStroke("S"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem2.addActionListener(actionListener);
        jMenuItem3.addActionListener(actionListener);
        jMenuItem4.addActionListener(actionListener);
        jMenuItem5.addActionListener(actionListener);
        jMenuItem6.addActionListener(actionListener);
        jMenuItem7.addActionListener(actionListener);
        jMenuItem9.addActionListener(actionListener);
        jMenuItem10.addActionListener(actionListener);
        jMenuItem12.addActionListener(actionListener);
        jMenuItem11.addActionListener(actionListener);
        jMenuItem8.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem6);
        jMenu.add(jMenuItem7);
        jMenu.add(jMenuItem8);
        jMenu.add(jMenuItem10);
        jMenu.addSeparator();
        jMenu.add(jMenuItem9);
        jMenu.addSeparator();
        jMenu.add(jMenuItem11);
        jMenu.add(jMenuItem12);
        return jMenu;
    }

    public JMenu defineViewMenu(ActionListener actionListener) {
        JMenu jMenu = new JMenu(Globals.messages.getString("View"));
        JMenuItem jMenuItem = new JMenuItem(Globals.messages.getString("Layer_opt"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, Globals.shortcutKey));
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(Globals.messages.getString("Attach_image_menu"));
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        this.libs = new JCheckBoxMenuItem(Globals.messages.getString("Libs"));
        jMenu.add(this.libs);
        this.libs.addActionListener(actionListener);
        return jMenu;
    }

    public JMenu defineCircuitMenu(ActionListener actionListener) {
        JMenu jMenu = new JMenu(Globals.messages.getString("Circuit"));
        JMenuItem jMenuItem = new JMenuItem(Globals.messages.getString("Define"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, Globals.shortcutKey));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(Globals.messages.getString("LibraryUpdate"));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(85, Globals.shortcutKey));
        jMenu.add(jMenuItem2);
        jMenuItem.addActionListener(actionListener);
        jMenuItem2.addActionListener(actionListener);
        return jMenu;
    }

    public void setShowLibsState(boolean bl) {
        this.libs.setState(bl);
    }

    public JMenu defineAboutMenu(ActionListener actionListener) {
        JMenu jMenu = new JMenu(Globals.messages.getString("About"));
        JMenuItem jMenuItem = new JMenuItem(Globals.messages.getString("About_menu"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        return jMenu;
    }

    public void processMenuActions(ActionEvent actionEvent, FidoFrame fidoFrame, ChangeCoordinatesListener changeCoordinatesListener) {
        ExportTools exportTools = fidoFrame.getExportTools();
        exportTools.setCoordinateListener(changeCoordinatesListener);
        PrintTools printTools = fidoFrame.getPrintTools();
        CircuitPanel circuitPanel = fidoFrame.cc;
        String string = actionEvent.getActionCommand();
        EditorActions editorActions = circuitPanel.getEditorActions();
        CopyPasteActions copyPasteActions = circuitPanel.getCopyPasteActions();
        ContinuosMoveActions continuosMoveActions = circuitPanel.getContinuosMoveActions();
        SelectionActions selectionActions = circuitPanel.getSelectionActions();
        ParserActions parserActions = circuitPanel.getParserActions();
        if (string.equals(Globals.messages.getString("Define"))) {
            EnterCircuitFrame enterCircuitFrame = new EnterCircuitFrame(fidoFrame, circuitPanel.getParserActions().getText(!circuitPanel.extStrict).toString());
            enterCircuitFrame.setVisible(true);
            parserActions.parseString(new StringBuffer(enterCircuitFrame.getStringCircuit()));
            circuitPanel.getUndoActions().saveUndoState();
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("LibraryUpdate"))) {
            fidoFrame.loadLibraries();
            fidoFrame.show();
        } else if (string.equals(Globals.messages.getString("Circ_opt"))) {
            fidoFrame.showPrefs();
        } else if (string.equals(Globals.messages.getString("Layer_opt"))) {
            DialogLayer dialogLayer = new DialogLayer(fidoFrame, circuitPanel.dmp.getLayers());
            dialogLayer.setVisible(true);
            circuitPanel.dmp.setChanged(true);
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("Libs"))) {
            fidoFrame.showLibs(!fidoFrame.areLibsVisible());
            this.libs.setState(fidoFrame.areLibsVisible());
        } else if (string.equals(Globals.messages.getString("Print"))) {
            printTools.associateToCircuitPanel(circuitPanel);
            printTools.printDrawing(fidoFrame);
        } else if (string.equals(Globals.messages.getString("SaveName"))) {
            fidoFrame.getFileTools().saveWithName(false);
        } else if (string.equals(Globals.messages.getString("Save_split"))) {
            fidoFrame.getFileTools().saveWithName(true);
        } else if (string.equals(Globals.messages.getString("Save"))) {
            fidoFrame.getFileTools().save(false);
        } else if (string.equals(Globals.messages.getString("New"))) {
            fidoFrame.createNewInstance();
        } else if (string.equals(Globals.messages.getString("Undo"))) {
            circuitPanel.getUndoActions().undo();
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("Redo"))) {
            circuitPanel.getUndoActions().redo();
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("About_menu"))) {
            DialogAbout dialogAbout = new DialogAbout(fidoFrame);
            dialogAbout.setVisible(true);
        } else if (string.equals(Globals.messages.getString("Open"))) {
            OpenFile openFile = new OpenFile();
            openFile.setParam(fidoFrame);
            SwingUtilities.invokeLater(openFile);
        } else if (string.equals(Globals.messages.getString("Export"))) {
            exportTools.launchExport(fidoFrame, circuitPanel, fidoFrame.getFileTools().openFileDirectory);
        } else if (string.equals(Globals.messages.getString("SelectAll"))) {
            selectionActions.setSelectionAll(true);
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("Copy"))) {
            copyPasteActions.copySelected(!circuitPanel.extStrict, false);
        } else if (string.equals(Globals.messages.getString("Copy_split"))) {
            copyPasteActions.copySelected(!circuitPanel.extStrict, true);
        } else if (string.equals(Globals.messages.getString("Copy_as_image"))) {
            exportTools.exportAsCopiedImage(fidoFrame, circuitPanel);
        } else if (string.equals(Globals.messages.getString("Cut"))) {
            copyPasteActions.copySelected(!circuitPanel.extStrict, false);
            editorActions.deleteAllSelected(true);
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("Mirror_E"))) {
            if (continuosMoveActions.isEnteringMacro()) {
                continuosMoveActions.mirrorMacro();
            } else {
                editorActions.mirrorAllSelected();
            }
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("Rotate"))) {
            if (continuosMoveActions.isEnteringMacro()) {
                continuosMoveActions.rotateMacro();
            } else {
                editorActions.rotateAllSelected();
            }
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("Duplicate"))) {
            copyPasteActions.copySelected(!circuitPanel.extStrict, false);
            copyPasteActions.paste(circuitPanel.getMapCoordinates().getXGridStep(), circuitPanel.getMapCoordinates().getYGridStep());
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("DefineClipboard"))) {
            TextTransfer textTransfer = new TextTransfer();
            if (circuitPanel.getUndoActions().getModified()) {
                FidoFrame fidoFrame2 = fidoFrame.createNewInstance();
            } else {
                FidoFrame fidoFrame3 = fidoFrame;
            }
            parserActions.parseString(new StringBuffer(textTransfer.getClipboardContents()));
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("Paste"))) {
            copyPasteActions.paste(circuitPanel.getMapCoordinates().getXGridStep(), circuitPanel.getMapCoordinates().getYGridStep());
            fidoFrame.repaint();
        } else if (string.equals(Globals.messages.getString("Close"))) {
            if (!fidoFrame.getFileTools().checkIfToBeSaved()) {
                return;
            }
            fidoFrame.closeThisFrame();
        } else if (string.equals(Globals.messages.getString("Attach_image_menu"))) {
            ImageAsCanvas imageAsCanvas = fidoFrame.cc.getAttachedImage();
            DialogAttachImage dialogAttachImage = new DialogAttachImage(fidoFrame);
            dialogAttachImage.setFilename(imageAsCanvas.getFilename());
            dialogAttachImage.setCorner(imageAsCanvas.getCornerX(), imageAsCanvas.getCornerY());
            dialogAttachImage.setResolution(imageAsCanvas.getResolution());
            dialogAttachImage.setVisible(true);
            if (dialogAttachImage.shouldAttach()) {
                try {
                    if (dialogAttachImage.getShowImage()) {
                        imageAsCanvas.loadImage(dialogAttachImage.getFilename());
                    } else {
                        imageAsCanvas.removeImage();
                    }
                    imageAsCanvas.setResolution(dialogAttachImage.getResolution());
                    imageAsCanvas.setCorner(dialogAttachImage.getCornerX(), dialogAttachImage.getCornerY());
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(fidoFrame, Globals.messages.getString("Can_not_attach_image"), "", 1);
                }
            }
        }
    }
}

