/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.fidocadj.FidoFrame;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.export.ExportGraphic;
import net.sourceforge.fidocadj.globals.Globals;

public class FileTools {
    private final FidoFrame fff;
    private final Preferences prefs;
    public String openFileDirectory;

    public FileTools(FidoFrame fidoFrame, Preferences preferences) {
        this.fff = fidoFrame;
        this.prefs = preferences;
        this.openFileDirectory = "";
    }

    public void readPrefs() {
        if (this.prefs != null) {
            this.openFileDirectory = this.prefs.get("OPEN_DIR", "");
        }
    }

    public boolean checkIfToBeSaved() {
        boolean bl = true;
        if (this.fff.cc.getUndoActions().getModified()) {
            int n;
            Object[] objectArray = new Object[]{Globals.messages.getString("Save"), Globals.messages.getString("Do_Not_Save"), Globals.messages.getString("Cancel_btn")};
            String string = Globals.messages.getString("Warning");
            if (!"".equals(this.fff.cc.getParserActions().openFileName)) {
                string = this.fff.cc.getParserActions().openFileName;
            }
            if ((n = JOptionPane.showOptionDialog(this.fff, Globals.messages.getString("Warning_unsaved"), Globals.prettifyPath(string, 35), 1, 3, null, objectArray, objectArray[0])) == 0) {
                if (!this.save(false)) {
                    bl = false;
                }
            } else if (n == 2) {
                bl = false;
            }
        }
        if (bl) {
            this.fff.cc.getUndoActions().doTheDishes();
        }
        return bl;
    }

    public void openFile() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fff.cc.getParserActions().openFileName), "UTF8"));
        StringBuffer stringBuffer = new StringBuffer();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        this.fff.cc.getParserActions().parseString(new StringBuffer(stringBuffer.toString()));
        this.fff.zoomToFit();
        this.fff.cc.getUndoActions().saveUndoState();
        this.fff.cc.getUndoActions().setModified(false);
        this.fff.repaint();
    }

    public boolean saveWithName(boolean bl) {
        String string;
        String string2;
        if (Globals.useNativeFileDialogs) {
            FileDialog fileDialog = new FileDialog((Frame)this.fff, Globals.messages.getString("SaveName"), 1);
            fileDialog.setDirectory(this.openFileDirectory);
            fileDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase(FileTools.this.fff.getLocale()).endsWith(".fcd");
                }
            });
            fileDialog.setVisible(true);
            string2 = fileDialog.getFile();
            string = fileDialog.getDirectory();
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".fcd") || file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "FidoCadJ (.fcd)";
                }
            });
            jFileChooser.setCurrentDirectory(new File(this.openFileDirectory));
            jFileChooser.setDialogTitle(Globals.messages.getString("SaveName"));
            if (jFileChooser.showSaveDialog(this.fff) != 0) {
                return false;
            }
            string2 = jFileChooser.getSelectedFile().getName();
            string = jFileChooser.getSelectedFile().getParentFile().getPath();
        }
        if (string2 == null) {
            return false;
        }
        this.fff.cc.getParserActions().openFileName = Globals.createCompleteFileName(string, string2);
        this.fff.cc.getParserActions().openFileName = Globals.adjustExtension(this.fff.cc.getParserActions().openFileName, "fcd");
        if (this.prefs != null) {
            this.prefs.put("OPEN_DIR", string);
        }
        this.openFileDirectory = string;
        return this.save(bl);
    }

    public boolean save(boolean bl) {
        CircuitPanel circuitPanel = this.fff.cc;
        if ("".equals(circuitPanel.getParserActions().openFileName)) {
            return this.saveWithName(bl);
        }
        try {
            if (bl) {
                ExportGraphic.export(new File(circuitPanel.getParserActions().openFileName), circuitPanel.dmp, "fcd", 1.0, true, false, !circuitPanel.extStrict, false, false);
                circuitPanel.getUndoActions().setModified(false);
            } else {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(circuitPanel.getParserActions().openFileName), "UTF8"));
                bufferedWriter.write("[FIDOCAD]\n");
                bufferedWriter.write(circuitPanel.getParserActions().getText(!circuitPanel.extStrict).toString());
                bufferedWriter.close();
                circuitPanel.getUndoActions().setModified(false);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.fff, Globals.messages.getString("Save_error") + iOException);
            return false;
        }
        return true;
    }

    public void load(String string) {
        this.fff.cc.getParserActions().openFileName = string;
        try {
            this.openFile();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.fff, Globals.messages.getString("Open_error") + iOException);
        }
    }
}

