/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import net.sourceforge.fidocadj.CommandLineParser;
import net.sourceforge.fidocadj.CreateSwingInterface;
import net.sourceforge.fidocadj.FidoFrame;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.circuit.model.DrawingModel;
import net.sourceforge.fidocadj.export.ExportGraphic;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.globals.FileUtils;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.graphic.DimensionG;
import net.sourceforge.fidocadj.graphic.PointG;
import net.sourceforge.fidocadj.layers.StandardLayers;
import net.sourceforge.fidocadj.timer.MyTimer;

public class FidoMain {
    private static CommandLineParser clp;

    public static void main(String ... stringArray) {
        clp = new CommandLineParser();
        if (stringArray.length >= 1) {
            clp.processArguments(stringArray);
        }
        FidoMain.applyOptimizationSettings(clp);
        if (clp.getHeadlessMode()) {
            Object object;
            DrawingModel drawingModel = new DrawingModel();
            if ("".equals(clp.getLoadFileName())) {
                System.err.println("You should specify a FidoCadJ file to read");
                System.exit(1);
            }
            FidoMain.readLibrariesProbeDirectory(drawingModel, false, clp.getLibDirectory());
            drawingModel.setLayers(StandardLayers.createStandardLayers());
            ParserActions parserActions = new ParserActions(drawingModel);
            MyTimer myTimer = new MyTimer();
            try {
                object = FileUtils.readFile(clp.getLoadFileName());
                parserActions.parseString(new StringBuffer((String)object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Illegal filename");
            }
            catch (Exception exception) {
                System.err.println("Unable to process: " + exception);
            }
            if (clp.shouldConvertFile()) {
                FidoMain.doConvert(clp, drawingModel, clp.shouldSplitLayers());
            }
            if (clp.getHasToPrintSize()) {
                object = new PointG(0, 0);
                DimensionG dimensionG = DrawingSize.getImageSize(drawingModel, 1.0, true, (PointG)object);
                System.out.println(dimensionG.width + " " + dimensionG.height);
            }
            if (clp.getHasToPrintTime()) {
                System.out.println("Elapsed time: " + myTimer.getElapsed() + " ms.");
            }
        }
        if (!clp.getCommandLineOnly()) {
            SwingUtilities.invokeLater(new CreateSwingInterface(clp.getLibDirectory(), clp.getLoadFileName(), clp.getWantedLocale()));
        }
    }

    private static void applyOptimizationSettings(CommandLineParser commandLineParser) {
        if (!commandLineParser.getStripOptimization() && System.getProperty("os.name").startsWith("Mac")) {
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
        }
    }

    private static void doConvert(CommandLineParser commandLineParser, DrawingModel drawingModel, boolean bl) {
        if (!Globals.checkExtension(commandLineParser.getOutputFile(), commandLineParser.getExportFormat()) && !commandLineParser.getForceMode()) {
            System.err.println("File extension is not coherent with the export output format! Use -f to skip this test.");
            System.exit(1);
        }
        try {
            if (commandLineParser.getResolutionBasedExport()) {
                ExportGraphic.export(new File(commandLineParser.getOutputFile()), drawingModel, commandLineParser.getExportFormat(), commandLineParser.getResolution(), true, false, true, true, bl);
            } else {
                ExportGraphic.exportSize(new File(commandLineParser.getOutputFile()), drawingModel, commandLineParser.getExportFormat(), commandLineParser.getXSize(), commandLineParser.getYSize(), true, false, true, true, bl);
            }
            System.out.println("Export completed");
        }
        catch (IOException iOException) {
            System.err.println("Export error: " + iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readLibrariesProbeDirectory(DrawingModel drawingModel, boolean bl, String string) {
        String string2 = string;
        ParserActions parserActions = new ParserActions(drawingModel);
        DrawingModel drawingModel2 = drawingModel;
        synchronized (drawingModel2) {
            if (string2 == null || string2.length() < 3) {
                string2 = System.getProperty("user.home");
            }
            FidoMain.readIHRAM(bl, string2, parserActions);
            FidoMain.readFCDstdlib(bl, string2, parserActions);
            FidoMain.readPCBlib(bl, string2, parserActions);
            FidoMain.readEY_Libraries(bl, string2, parserActions);
            FidoMain.readElecLib(bl, string2, parserActions);
        }
    }

    private static void readIHRAM(boolean bl, String string, ParserActions parserActions) {
        parserActions.loadLibraryDirectory(string);
        if (new File(Globals.createCompleteFileName(string, "IHRAM.FCL")).exists()) {
            System.out.println("IHRAM library got from external file");
        } else if (bl) {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM_en.FCL"), "ihram");
        } else {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM.FCL"), "ihram");
        }
    }

    private static void readFCDstdlib(boolean bl, String string, ParserActions parserActions) {
        if (new File(Globals.createCompleteFileName(string, "FCDstdlib.fcl")).exists()) {
            System.out.println("Standard library got from external file");
        } else if (bl) {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib_en.fcl"), "");
        } else {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib.fcl"), "");
        }
    }

    private static void readPCBlib(boolean bl, String string, ParserActions parserActions) {
        if (new File(Globals.createCompleteFileName(string, "PCB.fcl")).exists()) {
            System.out.println("Standard PCB library got from external file");
        } else if (bl) {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB_en.fcl"), "pcb");
        } else {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB.fcl"), "pcb");
        }
    }

    private static void readEY_Libraries(boolean bl, String string, ParserActions parserActions) {
        if (new File(Globals.createCompleteFileName(string, "EY_Libraries.fcl")).exists()) {
            System.out.println("Standard EY_Libraries got from external file");
        } else {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/EY_Libraries.fcl"), "EY_Libraries");
        }
    }

    private static void readElecLib(boolean bl, String string, ParserActions parserActions) {
        if (new File(Globals.createCompleteFileName(string, "elettrotecnica.fcl")).exists()) {
            System.out.println("Electrotechnics library got from external file");
        } else if (bl) {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica_en.fcl"), "elettrotecnica");
        } else {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica.fcl"), "elettrotecnica");
        }
    }
}

