/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.sourceforge.fidocadj.DragDropTools;
import net.sourceforge.fidocadj.ExportTools;
import net.sourceforge.fidocadj.FidoMain;
import net.sourceforge.fidocadj.FileTools;
import net.sourceforge.fidocadj.MenuTools;
import net.sourceforge.fidocadj.PrintTools;
import net.sourceforge.fidocadj.ScrollGestureRecognizer;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.circuit.HasChangedListener;
import net.sourceforge.fidocadj.circuit.controllers.AddElements;
import net.sourceforge.fidocadj.circuit.controllers.ContinuosMoveActions;
import net.sourceforge.fidocadj.circuit.controllers.CopyPasteActions;
import net.sourceforge.fidocadj.circuit.controllers.ParserActions;
import net.sourceforge.fidocadj.dialogs.DialogAbout;
import net.sourceforge.fidocadj.dialogs.DialogOptions;
import net.sourceforge.fidocadj.dialogs.DialogUtil;
import net.sourceforge.fidocadj.geom.DrawingSize;
import net.sourceforge.fidocadj.geom.MapCoordinates;
import net.sourceforge.fidocadj.globals.AccessResources;
import net.sourceforge.fidocadj.globals.Globals;
import net.sourceforge.fidocadj.globals.LibUtils;
import net.sourceforge.fidocadj.globals.Utf8ResourceBundle;
import net.sourceforge.fidocadj.layermodel.LayerModel;
import net.sourceforge.fidocadj.layers.LayerDesc;
import net.sourceforge.fidocadj.layers.StandardLayers;
import net.sourceforge.fidocadj.librarymodel.LibraryModel;
import net.sourceforge.fidocadj.librarymodel.utils.CircuitPanelUpdater;
import net.sourceforge.fidocadj.librarymodel.utils.LibraryUndoExecutor;
import net.sourceforge.fidocadj.macropicker.MacroTree;
import net.sourceforge.fidocadj.toolbars.ToolbarTools;
import net.sourceforge.fidocadj.toolbars.ToolbarZoom;
import net.sourceforge.fidocadj.toolbars.ZoomToFitListener;

public class FidoFrame
extends JFrame
implements ActionListener,
ZoomToFitListener,
HasChangedListener,
WindowFocusListener {
    public CircuitPanel cc;
    private JScrollPane sc;
    private JSplitPane splitPane;
    MacroTree macroLib;
    private LibraryModel libraryModel;
    private final ExportTools et;
    private final PrintTools pt;
    private final MenuTools mt;
    private final DragDropTools dt;
    private final FileTools ft;
    public String libDirectory;
    public Preferences prefs;
    private ToolbarTools toolBar;
    ToolbarZoom toolZoom;
    private boolean textToolbar;
    private boolean smallIconsToolbar;
    private JCheckBoxMenuItem optionMacroOrigin;
    public Locale currentLocale;
    public boolean runsAsApplication;
    private ScrollGestureRecognizer sgr;

    public FidoFrame(boolean bl, Locale locale) {
        super("FidoCadJ 0.24.8");
        this.runsAsApplication = bl;
        this.currentLocale = this.registerLocale(locale);
        this.getRootPane().putClientProperty("Aqua.windowStyle", "combinedToolBar");
        this.prepareLanguageResources();
        Globals.configureInterfaceDetailsFromPlatform(4, 2);
        DialogUtil.center(this, 0.75, 0.75, 800, 500);
        this.setDefaultCloseOperation(0);
        ++Globals.openWindowsNumber;
        Globals.openWindows.add(this);
        this.setIconForApplication();
        if (this.runsAsApplication) {
            FidoMain fidoMain = new FidoMain();
            this.prefs = Preferences.userNodeForPackage(fidoMain.getClass());
        } else {
            this.libDirectory = System.getProperty("user.home");
            this.smallIconsToolbar = false;
            this.textToolbar = true;
            this.prefs = null;
        }
        this.et = new ExportTools(this.prefs);
        this.pt = new PrintTools();
        this.mt = new MenuTools();
        this.dt = new DragDropTools(this);
        this.ft = new FileTools(this, this.prefs);
        this.readPreferences();
        if (Globals.openWindowsNumber == 1) {
            this.restorePosition();
        }
    }

    public void savePosition() {
        if (!this.runsAsApplication) {
            return;
        }
        int n = this.getExtendedState();
        this.setExtendedState(0);
        Rectangle rectangle = this.getBounds();
        int n2 = (int)rectangle.getX();
        int n3 = (int)rectangle.getY();
        int n4 = (int)rectangle.getWidth();
        int n5 = (int)rectangle.getHeight();
        this.prefs.put("FRAME_POSITION_X", "" + n2);
        this.prefs.put("FRAME_POSITION_Y", "" + n3);
        this.prefs.put("FRAME_WIDTH", "" + n4);
        this.prefs.put("FRAME_HEIGHT", "" + n5);
        this.prefs.put("FRAME_STATE", "" + n);
    }

    public final void restorePosition() {
        if (!this.runsAsApplication) {
            return;
        }
        try {
            int n = Integer.parseInt(this.prefs.get("FRAME_POSITION_X", "no"));
            int n2 = Integer.parseInt(this.prefs.get("FRAME_POSITION_Y", "no"));
            int n3 = Integer.parseInt(this.prefs.get("FRAME_WIDTH", "no"));
            int n4 = Integer.parseInt(this.prefs.get("FRAME_HEIGHT", "no"));
            int n5 = Integer.parseInt(this.prefs.get("FRAME_STATE", "no"));
            if ((n5 & 2) > 0 || (n5 & 4) > 0) {
                this.setExtendedState(n5);
            } else {
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                this.setBounds(rectangle);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Choosing default values for frame size");
        }
    }

    private void prepareLanguageResources() {
        try {
            Globals.messages = new AccessResources(Utf8ResourceBundle.getBundle("MessagesBundle", this.currentLocale));
        }
        catch (MissingResourceException missingResourceException) {
            try {
                Globals.messages = new AccessResources(ResourceBundle.getBundle("MessagesBundle", new Locale("en", "US")));
                System.out.println("No locale available, sorry... interface will be in English");
            }
            catch (MissingResourceException missingResourceException2) {
                JOptionPane.showMessageDialog(null, "Unable to find any language localization files: " + missingResourceException2);
                System.exit(1);
            }
        }
    }

    private void setIconForApplication() {
        URL uRL = DialogAbout.class.getResource("icona_fidocadj_128x128.png");
        if (uRL == null) {
            System.err.println("Could not retrieve the FidoCadJ icon!");
        } else {
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.setIconImage(image);
        }
    }

    private Locale registerLocale(Locale locale) {
        Locale locale2;
        String string = Locale.getDefault().getLanguage();
        if (locale == null) {
            locale2 = new Locale(string);
        } else {
            locale2 = locale;
            if (!locale.getLanguage().equals(string)) {
                System.out.println("Forcing the locale to be: " + locale + " instead of: " + string);
            }
        }
        return locale2;
    }

    @Override
    public Locale getLocale() {
        return this.currentLocale;
    }

    public ExportTools getExportTools() {
        return this.et;
    }

    public PrintTools getPrintTools() {
        return this.pt;
    }

    public FileTools getFileTools() {
        return this.ft;
    }

    public final void readPreferences() {
        if (this.prefs == null) {
            return;
        }
        this.libDirectory = this.prefs.get("DIR_LIBS", "");
        String string = "";
        string = "false";
        this.smallIconsToolbar = this.prefs.get("SMALL_ICON_TOOLBAR", string).equals("true");
        this.textToolbar = this.prefs.get("TEXT_TOOLBAR", "true").equals("true");
        this.et.readPrefs();
        this.ft.readPrefs();
        Globals.lineWidth = Double.parseDouble(this.prefs.get("STROKE_SIZE_STRAIGHT", "0.5"));
        Globals.lineWidthCircles = Double.parseDouble(this.prefs.get("STROKE_SIZE_OVAL", "0.35"));
        Globals.diameterConnection = Double.parseDouble(this.prefs.get("CONNECTION_SIZE", "2.0"));
    }

    public void readGridSettings() {
        this.cc.getMapCoordinates().setXGridStep(Integer.parseInt(this.prefs.get("GRID_SIZE", "5")));
        this.cc.getMapCoordinates().setYGridStep(Integer.parseInt(this.prefs.get("GRID_SIZE", "5")));
    }

    public void readDrawingSettings() {
        CopyPasteActions copyPasteActions = this.cc.getCopyPasteActions();
        copyPasteActions.setShiftCopyPaste(this.prefs.get("SHIFT_CP", "true").equals("true"));
        AddElements addElements = this.cc.getContinuosMoveActions().getAddElements();
        addElements.pcbPadSizeX = Integer.parseInt(this.prefs.get("PCB_pad_sizex", "10"));
        addElements.pcbPadSizeY = Integer.parseInt(this.prefs.get("PCB_pad_sizey", "10"));
        addElements.pcbPadStyle = Integer.parseInt(this.prefs.get("PCB_pad_style", "0"));
        addElements.pcbPadDrill = Integer.parseInt(this.prefs.get("PCB_pad_drill", "5"));
        addElements.pcbThickness = Integer.parseInt(this.prefs.get("PCB_thickness", "5"));
        MapCoordinates mapCoordinates = this.cc.getMapCoordinates();
        double d = Double.parseDouble(this.prefs.get("CURRENT_ZOOM", "4.0"));
        mapCoordinates.setMagnitudes(d, d);
    }

    public void loadLibraries() {
        boolean bl = !this.currentLocale.getLanguage().equals(new Locale("it", "", "").getLanguage());
        this.cc.dmp.resetLibrary();
        ParserActions parserActions = this.cc.getParserActions();
        if (this.runsAsApplication) {
            FidoMain.readLibrariesProbeDirectory(this.cc.dmp, bl, this.libDirectory);
        } else if (bl) {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM_en.FCL"), "ihram");
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib_en.fcl"), "");
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB_en.fcl"), "pcb");
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica_en.fcl"), "elettrotecnica");
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/EY_Libraries.fcl"), "EY_Libraries");
        } else {
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM.FCL"), "ihram");
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib.fcl"), "");
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB.fcl"), "pcb");
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica.fcl"), "elettrotecnica");
            parserActions.loadLibraryInJar(FidoFrame.class.getResource("lib/EY_Libraries.fcl"), "EY_Libraries");
        }
        this.libraryModel.forceUpdate();
    }

    public void init() {
        Container container = this.getContentPane();
        this.cc = new CircuitPanel(true);
        this.cc.getParserActions().openFileName = "";
        DropTarget dropTarget = new DropTarget(this.cc, this.dt);
        if (this.runsAsApplication) {
            this.cc.dmp.setTextFont(this.prefs.get("MACRO_FONT", "Courier New"), Integer.parseInt(this.prefs.get("MACRO_SIZE", "3")), this.cc.getUndoActions());
            this.readGridSettings();
            this.readDrawingSettings();
        }
        this.cc.setStrictCompatibility(false);
        this.cc.setPreferredSize(new Dimension(1000, 1000));
        this.cc.father = this.sc = new JScrollPane(this.cc);
        this.sc.setHorizontalScrollBarPolicy(32);
        this.sc.setVerticalScrollBarPolicy(22);
        if (this.runsAsApplication) {
            this.sgr = new ScrollGestureRecognizer();
            this.cc.addScrollGestureSelectionListener(this.sgr);
            FidoFrame fidoFrame = this;
            fidoFrame.sgr.getInstance();
        }
        this.sc.getVerticalScrollBar().setUnitIncrement(20);
        this.sc.getHorizontalScrollBar().setUnitIncrement(20);
        this.cc.profileTime = false;
        this.cc.antiAlias = true;
        Vector<LayerDesc> vector = StandardLayers.createStandardLayers();
        this.cc.dmp.setLayers(vector);
        this.toolBar = new ToolbarTools(this.textToolbar, this.smallIconsToolbar);
        this.toolZoom = new ToolbarZoom(vector);
        this.toolBar.addSelectionListener(this.cc);
        this.toolZoom.addLayerListener(this.cc);
        this.toolZoom.addGridStateListener(this.cc);
        this.toolZoom.addZoomToFitListener(this);
        this.cc.addChangeZoomListener(this.toolZoom);
        this.cc.addChangeSelectionListener(this.toolBar);
        this.cc.getContinuosMoveActions().addChangeCoordinatesListener(this.toolZoom);
        this.toolZoom.addChangeZoomListener(this.cc);
        Box box = Box.createVerticalBox();
        box.add(this.toolBar);
        box.add(this.toolZoom);
        this.toolZoom.setFloatable(false);
        this.toolZoom.setRollover(false);
        JMenuBar jMenuBar = this.mt.defineMenuBar(this);
        this.setJMenuBar(jMenuBar);
        this.cc.setSelectionState(1, "");
        container.add((Component)box, "North");
        this.libraryModel = new LibraryModel(this.cc.dmp);
        LayerModel layerModel = new LayerModel(this.cc.dmp);
        this.macroLib = new MacroTree(this.libraryModel, layerModel);
        this.macroLib.setSelectionListener(this.cc);
        this.libraryModel.setUndoActorListener(this.cc.getUndoActions());
        this.libraryModel.addLibraryListener(new CircuitPanelUpdater(this));
        this.cc.getUndoActions().setLibraryUndoListener(new LibraryUndoExecutor(this, this.libraryModel));
        try {
            LibUtils.saveLibraryState(this.cc.getUndoActions());
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        this.splitPane = new JSplitPane(1);
        this.splitPane.putClientProperty("JSplitPane.style", "thick");
        Dimension dimension = this.getSize();
        this.cc.setPreferredSize(new Dimension(dimension.width * 85 / 100, 100));
        this.splitPane.setTopComponent(this.sc);
        this.macroLib.setPreferredSize(new Dimension(450, 200));
        this.splitPane.setBottomComponent(this.macroLib);
        this.splitPane.setResizeWeight(0.8);
        container.add((Component)this.splitPane, "Center");
        this.cc.getUndoActions().setHasChangedListener(this);
        this.cc.setFocusable(true);
        this.sc.setFocusable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (!FidoFrame.this.ft.checkIfToBeSaved()) {
                    return;
                }
                FidoFrame.this.closeThisFrame();
            }
        });
        this.addWindowFocusListener(this);
        Globals.activeWindow = this;
        this.cc.getUndoActions().setModified(false);
        if (this.runsAsApplication) {
            boolean bl = this.prefs.get("SHOW_LIBS", "true").equals("true");
            this.showLibs(bl);
            bl = this.prefs.get("SHOW_GRID", "true").equals("true");
            this.cc.setGridVisibility(bl);
            this.toolZoom.setShowGrid(bl);
            bl = this.prefs.get("SNAP_GRID", "true").equals("true");
            this.cc.setSnapState(bl);
            this.toolZoom.setSnapGrid(bl);
        }
    }

    public void closeThisFrame() {
        this.setVisible(false);
        this.cc.getUndoActions().doTheDishes();
        this.savePosition();
        MapCoordinates mapCoordinates = this.cc.getMapCoordinates();
        this.prefs.put("CURRENT_ZOOM", "" + mapCoordinates.getXMagnitude());
        if (this.areLibsVisible()) {
            this.prefs.put("SHOW_LIBS", "true");
        } else {
            this.prefs.put("SHOW_LIBS", "false");
        }
        if (this.cc.getGridVisibility()) {
            this.prefs.put("SHOW_GRID", "true");
        } else {
            this.prefs.put("SHOW_GRID", "false");
        }
        if (this.cc.getSnapState()) {
            this.prefs.put("SNAP_GRID", "true");
        } else {
            this.prefs.put("SNAP_GRID", "false");
        }
        this.dispose();
        Globals.openWindows.remove(this);
        if (--Globals.openWindowsNumber < 1 && this.runsAsApplication) {
            System.exit(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            this.mt.processMenuActions(actionEvent, this, this.toolZoom);
        }
    }

    public FidoFrame createNewInstance() {
        FidoFrame fidoFrame = new FidoFrame(this.runsAsApplication, this.currentLocale);
        fidoFrame.setBounds(this.getX() + 30, this.getY() + 30, fidoFrame.getWidth(), fidoFrame.getHeight());
        fidoFrame.init();
        fidoFrame.loadLibraries();
        fidoFrame.setExtendedState(this.getExtendedState());
        fidoFrame.setVisible(true);
        return fidoFrame;
    }

    public void showPrefs() {
        String string = this.libDirectory;
        CopyPasteActions copyPasteActions = this.cc.getCopyPasteActions();
        ContinuosMoveActions continuosMoveActions = this.cc.getContinuosMoveActions();
        AddElements addElements = continuosMoveActions.getAddElements();
        DialogOptions dialogOptions = new DialogOptions(this, this.cc.getMapCoordinates().getXMagnitude(), this.cc.profileTime, this.cc.antiAlias, this.cc.getMapCoordinates().getXGridStep(), this.libDirectory, this.textToolbar, this.smallIconsToolbar, addElements.getPCB_thickness(), addElements.getPCB_pad_sizex(), addElements.getPCB_pad_sizey(), addElements.getPCB_pad_drill(), this.cc.getStrictCompatibility(), this.cc.dmp.getTextFont(), Globals.lineWidth, Globals.lineWidthCircles, Globals.diameterConnection, this.cc.dmp.getTextFontSize(), copyPasteActions.getShiftCopyPaste());
        dialogOptions.setVisible(true);
        this.cc.profileTime = dialogOptions.profileTime;
        this.cc.antiAlias = dialogOptions.antiAlias;
        this.textToolbar = dialogOptions.textToolbar;
        this.smallIconsToolbar = dialogOptions.smallIconsToolbar;
        this.cc.getMapCoordinates().setMagnitudes(dialogOptions.zoomValue, dialogOptions.zoomValue);
        this.cc.getMapCoordinates().setXGridStep(dialogOptions.gridSize);
        this.cc.getMapCoordinates().setYGridStep(dialogOptions.gridSize);
        addElements.setPCB_thickness(dialogOptions.pcblinewidth_i);
        addElements.setPCB_pad_sizex(dialogOptions.pcbpadwidth_i);
        addElements.setPCB_pad_sizey(dialogOptions.pcbpadheight_i);
        addElements.setPCB_pad_drill(dialogOptions.pcbpadintw_i);
        this.cc.dmp.setTextFont(dialogOptions.macroFont, dialogOptions.macroSize_i, this.cc.getUndoActions());
        this.cc.setStrictCompatibility(dialogOptions.extStrict);
        this.toolBar.setStrictCompatibility(dialogOptions.extStrict);
        copyPasteActions.setShiftCopyPaste(dialogOptions.shiftCP);
        this.libDirectory = dialogOptions.libDirectory;
        Globals.lineWidth = dialogOptions.stroke_size_straight_i;
        Globals.lineWidthCircles = dialogOptions.stroke_size_straight_i;
        Globals.diameterConnection = dialogOptions.connectionSize_i;
        if (this.runsAsApplication) {
            this.prefs.put("DIR_LIBS", this.libDirectory);
            this.prefs.put("MACRO_FONT", this.cc.dmp.getTextFont());
            this.prefs.put("MACRO_SIZE", "" + this.cc.dmp.getTextFontSize());
            this.prefs.put("STROKE_SIZE_STRAIGHT", "" + Globals.lineWidth);
            this.prefs.put("STROKE_SIZE_OVAL", "" + Globals.lineWidthCircles);
            this.prefs.put("CONNECTION_SIZE", "" + Globals.diameterConnection);
            this.prefs.put("SMALL_ICON_TOOLBAR", this.smallIconsToolbar ? "true" : "false");
            this.prefs.put("TEXT_TOOLBAR", this.textToolbar ? "true" : "false");
            this.prefs.put("GRID_SIZE", "" + this.cc.getMapCoordinates().getXGridStep());
            this.prefs.put("pcbPadSizeX", "" + addElements.pcbPadSizeX);
            this.prefs.put("pcbPadSizeY", "" + addElements.pcbPadSizeY);
            this.prefs.put("pcbPadStyle", "" + addElements.pcbPadStyle);
            this.prefs.put("pcbPadDrill", "" + addElements.pcbPadDrill);
            this.prefs.put("pcbThickness", "" + addElements.pcbThickness);
            this.prefs.put("SHIFT_CP", copyPasteActions.getShiftCopyPaste() ? "true" : "false");
        }
        if (!this.libDirectory.equals(string)) {
            this.loadLibraries();
            this.show();
        }
        this.repaint();
    }

    @Override
    public void zoomToFit() {
        MapCoordinates mapCoordinates = DrawingSize.calculateZoomToFit(this.cc.dmp, this.sc.getViewport().getExtentSize().width - 35, this.sc.getViewport().getExtentSize().height - 35, true);
        double d = mapCoordinates.getXMagnitude();
        this.cc.getMapCoordinates().setMagnitudes(d, d);
        Rectangle rectangle = new Rectangle((int)mapCoordinates.getXCenter(), (int)mapCoordinates.getYCenter(), this.sc.getViewport().getExtentSize().width, this.sc.getViewport().getExtentSize().height);
        this.cc.updateSizeOfScrollBars(rectangle);
    }

    @Override
    public void somethingHasChanged() {
        if (Globals.weAreOnAMac) {
            this.getRootPane().putClientProperty("Window.documentModified", this.cc.getUndoActions().getModified());
            this.toolBar.setTitle(Globals.prettifyPath(this.cc.getParserActions().openFileName, 45));
        } else {
            this.setTitle("FidoCadJ 0.24.8 " + Globals.prettifyPath(this.cc.getParserActions().openFileName, 45) + (this.cc.getUndoActions().getModified() ? " *" : ""));
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        Globals.activeWindow = this;
        this.cc.requestFocusInWindow();
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
    }

    @Override
    public void showLibs(boolean bl) {
        this.splitPane.setBottomComponent(bl ? this.macroLib : null);
        this.toolZoom.setShowLibsState(this.areLibsVisible());
        this.mt.setShowLibsState(this.areLibsVisible());
        if (bl) {
            this.splitPane.setDividerLocation(0.75);
        }
        this.splitPane.revalidate();
    }

    public boolean areLibsVisible() {
        return this.splitPane.getBottomComponent() != null;
    }
}

