/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.fidocadj.RunExport;
import net.sourceforge.fidocadj.circuit.CircuitPanel;
import net.sourceforge.fidocadj.dialogs.DialogCopyAsImage;
import net.sourceforge.fidocadj.dialogs.DialogExport;
import net.sourceforge.fidocadj.geom.ChangeCoordinatesListener;
import net.sourceforge.fidocadj.globals.Globals;

public class ExportTools
implements ClipboardOwner {
    private String exportFileName = "";
    private String exportFormat;
    private boolean exportBlackWhite;
    private double exportUnitPerPixel;
    private double exportMagnification = 1.0;
    private int exportXsize;
    private int exportYsize;
    private boolean exportResolutionBased;
    private boolean splitLayers;
    private final Preferences prefs;
    private ChangeCoordinatesListener coordL;

    public ExportTools(Preferences preferences) {
        this.prefs = preferences;
        this.exportBlackWhite = false;
        this.exportFormat = "";
        this.splitLayers = false;
    }

    public void readPrefs() {
        if (this.prefs != null) {
            this.exportFormat = this.prefs.get("EXPORT_FORMAT", "png");
            this.exportUnitPerPixel = Double.parseDouble(this.prefs.get("EXPORT_UNITPERPIXEL", "1"));
            this.exportMagnification = Double.parseDouble(this.prefs.get("EXPORT_MAGNIFICATION", "1"));
            this.exportBlackWhite = this.prefs.get("EXPORT_BW", "false").equals("true");
            this.exportXsize = Integer.parseInt(this.prefs.get("EXPORT_XSIZE", "800"));
            this.exportYsize = Integer.parseInt(this.prefs.get("EXPORT_YSIZE", "600"));
            this.exportResolutionBased = this.prefs.get("EXPORT_RESOLUTION_BASED", "false").equals("true");
            this.splitLayers = this.prefs.get("EXPORT_SPLIT_LAYERS", "false").equals("true");
        }
    }

    public void exportAsCopiedImage(JFrame jFrame, CircuitPanel circuitPanel) {
        DialogCopyAsImage dialogCopyAsImage = new DialogCopyAsImage(jFrame, circuitPanel.getDrawingModel());
        dialogCopyAsImage.setAntiAlias(true);
        dialogCopyAsImage.setXsizeInPixels(this.exportXsize);
        dialogCopyAsImage.setYsizeInPixels(this.exportYsize);
        dialogCopyAsImage.setResolutionBasedExport(this.exportResolutionBased);
        dialogCopyAsImage.setUnitPerPixel(this.exportUnitPerPixel);
        dialogCopyAsImage.setBlackWhite(this.exportBlackWhite);
        dialogCopyAsImage.setVisible(true);
        if (dialogCopyAsImage.shouldExport()) {
            this.exportUnitPerPixel = dialogCopyAsImage.getUnitPerPixel();
            this.exportBlackWhite = dialogCopyAsImage.getBlackWhite();
            this.exportResolutionBased = dialogCopyAsImage.getResolutionBasedExport();
            try {
                this.exportXsize = dialogCopyAsImage.getXsizeInPixels();
                this.exportYsize = dialogCopyAsImage.getYsizeInPixels();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, Globals.messages.getString("Format_invalid"), Globals.messages.getString("Warning"), 1);
                this.exportXsize = 100;
                this.exportYsize = 100;
            }
            RunExport runExport = new RunExport();
            runExport.setCoordinateListener(this.coordL);
            try {
                File file = File.createTempFile("FidoCadJ", ".png");
                runExport.setParam(file, circuitPanel.dmp, "png", this.exportUnitPerPixel, dialogCopyAsImage.getAntiAlias(), this.exportBlackWhite, !circuitPanel.extStrict, this.exportResolutionBased, this.exportXsize, this.exportYsize, false, jFrame);
                runExport.run();
                BufferedImage bufferedImage = null;
                bufferedImage = ImageIO.read(file);
                this.setClipboard(bufferedImage);
            }
            catch (IOException iOException) {
                System.err.println("Issues reading image: " + iOException);
            }
            if (this.prefs != null) {
                this.prefs.put("EXPORT_UNITPERPIXEL", "" + this.exportUnitPerPixel);
                this.prefs.put("EXPORT_MAGNIFICATION", "" + this.exportMagnification);
                this.prefs.put("EXPORT_BW", this.exportBlackWhite ? "true" : "false");
                this.prefs.put("EXPORT_RESOLUTION_BASED", this.exportResolutionBased ? "true" : "false");
                this.prefs.put("EXPORT_XSIZE", "" + this.exportXsize);
                this.prefs.put("EXPORT_YSIZE", "" + this.exportYsize);
            }
        }
    }

    public void launchExport(JFrame jFrame, CircuitPanel circuitPanel, String string) {
        DialogExport dialogExport = new DialogExport(jFrame, circuitPanel.getDrawingModel());
        dialogExport.setAntiAlias(true);
        dialogExport.setFormat(this.exportFormat);
        dialogExport.setXsizeInPixels(this.exportXsize);
        dialogExport.setYsizeInPixels(this.exportYsize);
        dialogExport.setResolutionBasedExport(this.exportResolutionBased);
        dialogExport.setSplitLayers(this.splitLayers);
        if ("".equals(this.exportFileName)) {
            this.exportFileName = string;
        }
        dialogExport.setFileName(this.exportFileName);
        dialogExport.setUnitPerPixel(this.exportUnitPerPixel);
        dialogExport.setBlackWhite(this.exportBlackWhite);
        dialogExport.setMagnification(this.exportMagnification);
        dialogExport.setVisible(true);
        if (dialogExport.shouldExport()) {
            int n;
            this.exportFileName = dialogExport.getFileName();
            this.exportFormat = dialogExport.getFormat();
            if ("png".equals(this.exportFormat) || "jpg".equals(this.exportFormat)) {
                this.exportResolutionBased = dialogExport.getResolutionBasedExport();
                this.exportUnitPerPixel = dialogExport.getUnitPerPixel();
            } else {
                this.exportResolutionBased = true;
                this.exportUnitPerPixel = dialogExport.getMagnification();
            }
            this.exportBlackWhite = dialogExport.getBlackWhite();
            this.exportMagnification = dialogExport.getMagnification();
            this.splitLayers = dialogExport.getSplitLayers();
            try {
                this.exportXsize = dialogExport.getXsizeInPixels();
                this.exportYsize = dialogExport.getYsizeInPixels();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, Globals.messages.getString("Format_invalid"), Globals.messages.getString("Warning"), 1);
                this.exportXsize = 100;
                this.exportYsize = 100;
            }
            File file = new File(this.exportFileName);
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(null, Globals.messages.getString("Warning_noname"), Globals.messages.getString("Warning"), 1);
                return;
            }
            if (!Globals.checkExtension(this.exportFileName, this.exportFormat)) {
                n = JOptionPane.showConfirmDialog(null, Globals.messages.getString("Warning_extension"), Globals.messages.getString("Warning"), 0, 2);
                if (n == 0) {
                    this.exportFileName = Globals.adjustExtension(this.exportFileName, this.exportFormat);
                }
                file = new File(this.exportFileName);
            }
            if (file.exists() && (n = JOptionPane.showConfirmDialog(null, Globals.messages.getString("Warning_overwrite"), Globals.messages.getString("Warning"), 2, 2)) != 0) {
                return;
            }
            RunExport runExport = new RunExport();
            runExport.setCoordinateListener(this.coordL);
            runExport.setParam(new File(this.exportFileName), circuitPanel.dmp, this.exportFormat, this.exportUnitPerPixel, dialogExport.getAntiAlias(), this.exportBlackWhite, !circuitPanel.extStrict, this.exportResolutionBased, this.exportXsize, this.exportYsize, this.splitLayers, jFrame);
            SwingUtilities.invokeLater(runExport);
            if (this.prefs != null) {
                this.prefs.put("EXPORT_FORMAT", this.exportFormat);
                this.prefs.put("EXPORT_UNITPERPIXEL", "" + this.exportUnitPerPixel);
                this.prefs.put("EXPORT_MAGNIFICATION", "" + this.exportMagnification);
                this.prefs.put("EXPORT_BW", this.exportBlackWhite ? "true" : "false");
                this.prefs.put("EXPORT_RESOLUTION_BASED", this.exportResolutionBased ? "true" : "false");
                this.prefs.put("EXPORT_XSIZE", "" + this.exportXsize);
                this.prefs.put("EXPORT_YSIZE", "" + this.exportYsize);
                this.prefs.put("EXPORT_SPLIT_LAYERS", this.splitLayers ? "true" : "false");
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setCoordinateListener(ChangeCoordinatesListener changeCoordinatesListener) {
        this.coordL = changeCoordinatesListener;
    }

    public void setClipboard(Image image) {
        TransferableImage transferableImage = new TransferableImage(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferableImage, this);
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image image) {
            this.i = image;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }
    }
}

