/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.Window;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import net.sourceforge.fidocadj.ADesktopIntegration;
import net.sourceforge.fidocadj.FidoFrame;
import net.sourceforge.fidocadj.globals.Globals;

class CreateSwingInterface
implements Runnable {
    String libDirectory;
    String loadFile;
    Locale currentLocale;

    public CreateSwingInterface(String string, String string2, Locale locale) {
        this.libDirectory = string;
        this.loadFile = string2;
        this.currentLocale = locale;
    }

    public CreateSwingInterface() {
        this.libDirectory = "";
        this.loadFile = "";
    }

    @Override
    public void run() {
        Object object;
        if (System.getProperty("os.name").startsWith("Mac")) {
            object = new Globals();
            Preferences preferences = Preferences.userNodeForPackage(object.getClass());
            Globals.weAreOnAMac = true;
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FidoCadJ");
            try {
                System.out.println("Trying to activate VAqua7");
                UIManager.setLookAndFeel("org.violetlib.aqua.AquaLookAndFeel");
                System.out.println("VAqua7 look and feel active");
            }
            catch (Exception exception) {
                System.out.println("The Quaqua look and feel is not available");
                System.out.println("I will continue with the basic Apple l&f");
            }
        } else if (System.getProperty("os.name").startsWith("Win")) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception exception) {
                System.out.println("Could not load the Windows Look and feel!");
            }
        }
        Globals.desktopInt = new ADesktopIntegration();
        Globals.desktopInt.registerActions();
        if (Globals.weAreOnAMac) {
            // empty if block
        }
        object = new FidoFrame(true, this.currentLocale);
        if (!"".equals(this.libDirectory)) {
            ((FidoFrame)object).libDirectory = this.libDirectory;
        }
        ((FidoFrame)object).init();
        ((Window)object).setVisible(true);
        ((FidoFrame)object).loadLibraries();
        if (!"".equals(this.loadFile)) {
            ((FidoFrame)object).getFileTools().load(this.loadFile);
        }
        ((Window)object).setVisible(true);
    }
}

