/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.util.Locale;

public class CommandLineParser {
    private boolean commandLineOnly = false;
    private boolean forceMode = false;
    private boolean convertFile = false;
    private int totx = 0;
    private int toty = 0;
    private String exportFormat = "";
    private String outputFile = "";
    private boolean headlessMode = false;
    private boolean resolutionBasedExport = false;
    private boolean printSize = false;
    private boolean printTime = false;
    private boolean splitLayers = false;
    private double resolution = 1.0;
    private Locale currentLocale = null;
    private String loadFile = "";
    private String libDirectory = "";
    private static boolean stripOptimization = false;

    public boolean getStripOptimization() {
        return stripOptimization;
    }

    public String getLoadFileName() {
        return this.loadFile;
    }

    public String getLibDirectory() {
        return this.libDirectory;
    }

    public void processArguments(String ... stringArray) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray2 = stringArray;
        if (stringArray2[0].equalsIgnoreCase("-print")) {
            string = stringArray2[1].toLowerCase().replace(".fcd", "");
            if (string.lastIndexOf(System.getProperty("file.separator")) > 0) {
                string = string.substring(string.lastIndexOf(System.getProperty("file.separator")) + 1);
            }
            stringArray2 = ("-n -c r72 pdf " + string + ".pdf " + stringArray2[1]).split(" ");
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].startsWith("-")) {
                if (stringArray2[i].trim().equalsIgnoreCase("-open")) continue;
                if (stringArray2[i].startsWith("-k")) {
                    System.out.println("Detected locale: " + Locale.getDefault().getLanguage());
                    continue;
                }
                if (stringArray2[i].startsWith("-n")) {
                    this.commandLineOnly = true;
                    System.setProperty("java.awt.headless", "true");
                    continue;
                }
                if (stringArray2[i].startsWith("-d")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray2[i].startsWith("-f")) {
                    this.forceMode = true;
                    continue;
                }
                if (stringArray2[i].startsWith("-m")) {
                    this.splitLayers = true;
                    continue;
                }
                if (stringArray2[i].startsWith("-c")) {
                    try {
                        if (stringArray2[++i].startsWith("r")) {
                            this.resolution = Double.parseDouble(stringArray2[i].substring(1));
                            this.resolutionBasedExport = true;
                            if (this.resolution <= 0.0) {
                                System.err.println("Resolution should be a positive real number");
                                System.exit(1);
                            }
                        } else {
                            this.totx = Integer.parseInt(stringArray2[i]);
                            this.toty = Integer.parseInt(stringArray2[++i]);
                        }
                        this.exportFormat = stringArray2[++i];
                        this.outputFile = stringArray2[++i];
                        this.convertFile = true;
                        this.headlessMode = true;
                    }
                    catch (Exception exception) {
                        System.err.println("Unable to read the parameters given to -c");
                        System.exit(1);
                    }
                    this.convertFile = true;
                    continue;
                }
                if (stringArray2[i].startsWith("-h")) {
                    this.showCommandLineHelp();
                    System.exit(0);
                    continue;
                }
                if (stringArray2[i].startsWith("-s")) {
                    this.headlessMode = true;
                    this.printSize = true;
                    continue;
                }
                if (stringArray2[i].startsWith("-t")) {
                    this.printTime = true;
                    continue;
                }
                if (stringArray2[i].startsWith("-p")) {
                    stripOptimization = true;
                    continue;
                }
                if (stringArray2[i].startsWith("-l")) {
                    if (stringArray2[i].length() == 2) {
                        if (i == stringArray2.length - 1 || stringArray2[i + 1].startsWith("-")) {
                            System.err.println("-l option requires a locale language code.");
                            System.exit(1);
                        }
                        string = stringArray2[++i];
                    } else {
                        string = stringArray2[i].substring(2);
                    }
                    this.currentLocale = new Locale(string);
                    continue;
                }
                System.err.println("Unrecognized option: " + stringArray2[i]);
                this.showCommandLineHelp();
                System.exit(1);
                continue;
            }
            if (bl2) {
                this.libDirectory = stringArray2[i];
                System.out.println("Changed the library directory: " + stringArray2[i]);
            } else {
                if (bl) {
                    System.err.println("Only one file can be specified in the command line");
                }
                this.loadFile = stringArray2[i];
                bl = true;
            }
            bl2 = false;
        }
    }

    public void showCommandLineHelp() {
        String string = "\nThis is FidoCadJ, version 0.24.8.\nBy the FidoCadJ team, 2007-2020.\n\nUse: java -jar fidocadj-0.24.8.jar [-options] [file] \nwhere options include:\n\n -n     Do not start the graphical user interface (headless mode)\n\n -d     Set the extern library directory\n        Usage: -d dir\n        where 'dir' is the path of the directory you want to use.\n\n -c     Convert the given file to a graphical format.\n        Usage: -c sx sy eps|pdf|svg|png|jpg|fcd|sch outfile\n        If you use this command line option, you *must* specify a FidoCadJ\n        file to convert.\n        An alternative is to specify the resolution in pixels per logical unit\n        by preceding it by the letter 'r' (without spaces), instead of giving\n        sx and sy.\n        NOTE: the correctness of the file extension is checked, unless the -f\n        option is specified.\n\n -m     if a file export is done towards a vector graphic file format, split\n        the layers and write one file for each layer. The file name will be\n        obtained by appending _ followed by the layer number to the specified\n        file name. For example, the following command will create files\n        test_0.svg, test_1.svg ... from the drawing contained in test.fcd:\n\n           java -jar fidocadj.jar -n -m -c r2 svg test.svg test.fcd\n\n -s     Print the size of the specified file in logical units.\n\n -h     Print this help and exit.\n\n -t     Print the time used by FidoCadJ for the specified operation.\n\n -p     Do not activate some platform-dependent optimizations. You might try\n        this option if FidoCadJ hangs or is painfully slow.\n\n -l     Force FidoCadJ to use a certain locale (the code might follow\n        immediately or be separated by an optional space).\n\n -k     Show the current locale.\n\n -f     Force FidoCadJ to skip some sanity tests on the input data.\n\n [file] The optional (except if you use the -d or -s options) FidoCadJ file to\n        load at startup time.\n\nExample: load and convert a FidoCadJ drawing to a 800x600 pixel png file\n        without using the GUI.\n  java -jar fidocadj.jar -n -c 800 600 png out1.png test1.fcd\n\nExample: load and convert a FidoCadJ drawing to a png file without using the\n        graphic user interface (the so called headless mode).\n        Each FidoCadJ logical unit will be converted in 2 pixels on the image.\n  java -jar fidocadj.jar -n -c r2 png out2.png test2.fcd\n\nExample: load FidoCadJ forcing the locale to simplified Chinese (zh).\n  java -jar fidocadj.jar -l zh\n\n";
        System.out.println(string);
    }

    public boolean shouldSplitLayers() {
        return this.splitLayers;
    }

    public boolean shouldConvertFile() {
        return this.convertFile;
    }

    public String getExportFormat() {
        return this.exportFormat;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public int getXSize() {
        return this.totx;
    }

    public int getYSize() {
        return this.toty;
    }

    public boolean getHeadlessMode() {
        return this.headlessMode;
    }

    public boolean getResolutionBasedExport() {
        return this.resolutionBasedExport;
    }

    public Locale getWantedLocale() {
        return this.currentLocale;
    }

    public boolean getHasToPrintSize() {
        return this.printSize;
    }

    public boolean getHasToPrintTime() {
        return this.printTime;
    }

    public double getResolution() {
        return this.resolution;
    }

    public boolean getForceMode() {
        return this.forceMode;
    }

    public boolean getCommandLineOnly() {
        return this.commandLineOnly;
    }
}

