/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import java.awt.Desktop;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import javax.swing.JFrame;
import net.sourceforge.fidocadj.FidoFrame;
import net.sourceforge.fidocadj.dialogs.DialogAbout;
import net.sourceforge.fidocadj.globals.Globals;

public class ADesktopIntegration
implements AboutHandler,
PreferencesHandler,
QuitHandler,
OpenFilesHandler {
    public boolean handleAbout;
    public boolean handlePreferences;

    ADesktopIntegration() {
    }

    public void registerActions() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        this.handleAbout = true;
        this.handlePreferences = true;
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.setOpenFileHandler(this);
            desktop.setQuitHandler(this);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            desktop.setAboutHandler(this);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.handleAbout = false;
        }
        try {
            desktop.setPreferencesHandler(this);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.handlePreferences = false;
        }
    }

    @Override
    public void openFiles(OpenFilesEvent openFilesEvent) {
        String string = openFilesEvent.getFiles().get(0).getAbsolutePath();
        ((FidoFrame)Globals.activeWindow).getFileTools().load(string);
    }

    @Override
    public void handleAbout(AboutEvent aboutEvent) {
        DialogAbout dialogAbout = new DialogAbout((JFrame)Globals.activeWindow);
        dialogAbout.setVisible(true);
    }

    @Override
    public void handlePreferences(PreferencesEvent preferencesEvent) {
        ((FidoFrame)Globals.activeWindow).showPrefs();
    }

    @Override
    public void handleQuitRequestWith(QuitEvent quitEvent, QuitResponse quitResponse) {
        boolean bl = true;
        Object[] objectArray = Globals.openWindows.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            FidoFrame fidoFrame = (FidoFrame)objectArray[i];
            if (fidoFrame.getFileTools().checkIfToBeSaved()) {
                fidoFrame.closeThisFrame();
                continue;
            }
            bl = false;
        }
        if (bl) {
            quitResponse.performQuit();
        } else {
            quitResponse.cancelQuit();
        }
    }
}

